/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.property;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.regex.RegExHelper;
import saoui.shade.com.helger.css.ECSSVendorPrefix;
import saoui.shade.com.helger.css.property.AbstractCSSPropertyEnums;
import saoui.shade.com.helger.css.property.ECSSProperty;
import saoui.shade.com.helger.css.property.customizer.ICSSPropertyCustomizer;
import saoui.shade.com.helger.css.utils.CSSColorHelper;

@NotThreadSafe
public class CSSPropertyEnumOrColors
extends AbstractCSSPropertyEnums {
    public CSSPropertyEnumOrColors(@Nonnull ECSSProperty eCSSProperty, @Nonnegative int n, @Nonnegative int n2, String ... stringArray) {
        this(eCSSProperty, (ICSSPropertyCustomizer)null, n, n2, stringArray);
    }

    public CSSPropertyEnumOrColors(@Nonnull ECSSProperty eCSSProperty, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnegative int n, @Nonnegative int n2, String ... stringArray) {
        this(eCSSProperty, (ECSSVendorPrefix)null, iCSSPropertyCustomizer, n, n2, stringArray);
    }

    public CSSPropertyEnumOrColors(@Nonnull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnegative int n, @Nonnegative int n2, String ... stringArray) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer, n, n2, stringArray);
    }

    public CSSPropertyEnumOrColors(@Nonnull ECSSProperty eCSSProperty, @Nonnegative int n, @Nonnegative int n2, @Nonnull @Nonempty Iterable<String> iterable) {
        this(eCSSProperty, null, n, n2, iterable);
    }

    public CSSPropertyEnumOrColors(@Nonnull ECSSProperty eCSSProperty, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnegative int n, @Nonnegative int n2, @Nonnull @Nonempty Iterable<String> iterable) {
        this(eCSSProperty, (ECSSVendorPrefix)null, iCSSPropertyCustomizer, n, n2, iterable);
    }

    public CSSPropertyEnumOrColors(@Nonnull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnegative int n, @Nonnegative int n2, @Nonnull @Nonempty Iterable<String> iterable) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer, n, n2, iterable);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String string) {
        if (string == null) {
            return false;
        }
        String[] stringArray = RegExHelper.getSplitToArray(string.trim(), "\\s+");
        if (stringArray.length < this.getMinimumArgumentCount() || stringArray.length > this.getMaximumArgumentCount()) {
            return false;
        }
        for (String string2 : stringArray) {
            String string3 = string2.trim();
            if (super.isValidValue(string3) || CSSColorHelper.isColorValue(string3)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public CSSPropertyEnumOrColors getClone(@Nonnull ECSSProperty eCSSProperty) {
        return new CSSPropertyEnumOrColors(eCSSProperty, this.getVendorPrefix(), this.getCustomizer(), this.getMinimumArgumentCount(), this.getMaximumArgumentCount(), this.directGetEnumValues());
    }

    @Override
    @Nonnull
    public CSSPropertyEnumOrColors getClone(@Nullable ECSSVendorPrefix eCSSVendorPrefix) {
        return new CSSPropertyEnumOrColors(this.getProp(), eCSSVendorPrefix, this.getCustomizer(), this.getMinimumArgumentCount(), this.getMaximumArgumentCount(), this.directGetEnumValues());
    }
}

