/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.propertyvalue;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.string.StringHelper;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.com.helger.css.ICSSWriterSettings;
import saoui.shade.com.helger.css.property.ECSSProperty;
import saoui.shade.com.helger.css.property.ICSSProperty;
import saoui.shade.com.helger.css.propertyvalue.ICSSValue;
import saoui.shade.org.slf4j.Logger;
import saoui.shade.org.slf4j.LoggerFactory;

@NotThreadSafe
public class CSSValue
implements ICSSValue {
    public static final boolean DEFAULT_CONSISTENCY_CHECKS_ENABLED = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(CSSValue.class);
    private static boolean s_bConsistencyChecksEnabled = true;
    private ICSSProperty m_aProperty;
    private String m_sValue;
    private boolean m_bIsImportant;

    public static boolean areConsistencyChecksEnabled() {
        return s_bConsistencyChecksEnabled;
    }

    public static void setConsistencyChecksEnabled(boolean bl) {
        s_bConsistencyChecksEnabled = bl;
    }

    public CSSValue(@Nonnull ICSSProperty iCSSProperty, @Nonnull String string, boolean bl) {
        this.setProperty(iCSSProperty);
        this.setValue(string);
        this.setImportant(bl);
    }

    @Nonnull
    public ICSSProperty getProperty() {
        return this.m_aProperty;
    }

    @Override
    @Nonnull
    public ECSSProperty getProp() {
        return this.m_aProperty.getProp();
    }

    @Nonnull
    @Nonempty
    public String getPropertyName() {
        return this.m_aProperty.getPropertyName();
    }

    @Nonnull
    public CSSValue setProperty(@Nonnull ICSSProperty iCSSProperty) {
        this.m_aProperty = ValueEnforcer.notNull(iCSSProperty, "Property");
        return this;
    }

    @Nonnull
    public String getValue() {
        return this.m_sValue;
    }

    @Nonnull
    public CSSValue setValue(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Value");
        if (CSSValue.areConsistencyChecksEnabled()) {
            if (!this.m_aProperty.isValidValue(string)) {
                LOGGER.warn("CSS: the value '" + string + "' is not valid for property '" + this.m_aProperty.getPropertyName() + "'");
            }
            if (string.contains(" !important")) {
                LOGGER.warn("CSS: the value '" + string + "' should not contain the '" + " !important" + "' string! Use 'setImportant' method instead.");
            }
        }
        this.m_sValue = string.trim();
        return this;
    }

    public boolean isImportant() {
        return this.m_bIsImportant;
    }

    @Nonnull
    public CSSValue setImportant(boolean bl) {
        this.m_bIsImportant = bl;
        return this;
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this.m_aProperty);
        return this.m_aProperty.getPropertyName() + ':' + this.m_sValue + (StringHelper.hasText(this.m_sValue) && this.m_bIsImportant ? " !important" : "") + ';';
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSValue cSSValue = (CSSValue)object;
        return this.m_aProperty.getProp().equals(cSSValue.m_aProperty.getProp()) && this.m_sValue.equals(cSSValue.m_sValue) && this.m_bIsImportant == cSSValue.m_bIsImportant;
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_aProperty.getProp())).append(this.m_sValue).append(this.m_bIsImportant).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("property", this.m_aProperty).append("value", this.m_sValue).append("important", this.m_bIsImportant).getToString();
    }
}

