/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.reader.errorhandler;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.collection.impl.CommonsArrayList;
import saoui.shade.com.helger.commons.collection.impl.ICommonsList;
import saoui.shade.com.helger.commons.concurrent.SimpleReadWriteLock;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.com.helger.css.parser.ParseException;
import saoui.shade.com.helger.css.parser.Token;
import saoui.shade.com.helger.css.reader.errorhandler.CSSParseError;
import saoui.shade.com.helger.css.reader.errorhandler.ICSSParseErrorHandler;

@ThreadSafe
public class CollectingCSSParseErrorHandler
implements ICSSParseErrorHandler {
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsList<CSSParseError> m_aErrors = new CommonsArrayList<CSSParseError>();

    @Override
    public void onCSSParseError(@Nonnull ParseException parseException, @Nullable Token token) throws ParseException {
        this.m_aRWLock.writeLocked(() -> {
            if (parseException.expectedTokenSequences == null) {
                this.m_aErrors.add(new CSSParseError(parseException.getMessage()));
            } else {
                this.m_aErrors.add(new CSSParseError(parseException.currentToken, parseException.expectedTokenSequences, parseException.tokenImage, token));
            }
        });
    }

    @Override
    public void onCSSUnexpectedRule(@Nonnull Token token, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) throws ParseException {
        this.m_aRWLock.writeLocked(() -> this.m_aErrors.add(CSSParseError.createUnexpectedRule(token, string, string2)));
    }

    @Override
    public void onCSSDeprecatedProperty(@Nonnull Token token, @Nonnull Token token2) {
        this.m_aRWLock.writeLocked(() -> this.m_aErrors.add(CSSParseError.createDeprecatedProperty(token, token2)));
    }

    @Override
    public void onCSSBrowserCompliantSkip(@Nullable ParseException parseException, @Nonnull Token token, @Nonnull Token token2) throws ParseException {
        this.m_aRWLock.writeLocked(() -> this.m_aErrors.add(CSSParseError.createBrowserCompliantSkip(parseException, token, token2)));
    }

    @Override
    public void onIllegalCharacter(char c) {
        this.m_aRWLock.writeLocked(() -> this.m_aErrors.add(CSSParseError.createIllegalCharacter(c)));
    }

    @Nonnegative
    public boolean hasParseErrors() {
        return this.m_aRWLock.readLockedBoolean(this.m_aErrors::isNotEmpty);
    }

    @Nonnegative
    public int getParseErrorCount() {
        return this.m_aRWLock.readLockedInt(this.m_aErrors::size);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSParseError> getAllParseErrors() {
        return this.m_aRWLock.readLockedGet(this.m_aErrors::getClone);
    }

    public String toString() {
        return new ToStringGenerator(this).append("Errors", this.m_aErrors).getToString();
    }
}

