/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.utils;

import java.math.BigDecimal;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.collection.impl.CommonsHashMap;
import saoui.shade.com.helger.commons.collection.impl.ICommonsMap;
import saoui.shade.com.helger.commons.compare.IComparator;
import saoui.shade.com.helger.commons.string.StringHelper;
import saoui.shade.com.helger.commons.string.StringParser;
import saoui.shade.com.helger.css.ECSSUnit;
import saoui.shade.com.helger.css.propertyvalue.CSSSimpleValueWithUnit;

@Immutable
public final class CSSNumberHelper {
    private static final ICommonsMap<String, ECSSUnit> s_aNameToUnitMap;
    private static final CSSNumberHelper INSTANCE;

    private CSSNumberHelper() {
    }

    @Nullable
    public static ECSSUnit getMatchingUnitInclPercentage(@Nonnull String string) {
        ValueEnforcer.notNull(string, "CSSValue");
        for (Map.Entry entry : s_aNameToUnitMap.entrySet()) {
            if (!string.endsWith((String)entry.getKey())) continue;
            return (ECSSUnit)entry.getValue();
        }
        return null;
    }

    @Nullable
    public static ECSSUnit getMatchingUnitExclPercentage(@Nonnull String string) {
        ECSSUnit eCSSUnit = CSSNumberHelper.getMatchingUnitInclPercentage(string);
        return eCSSUnit == null || eCSSUnit == ECSSUnit.PERCENTAGE ? null : eCSSUnit;
    }

    public static boolean isNumberValue(@Nullable String string) {
        String string2 = StringHelper.trim(string);
        return StringHelper.hasText(string2) && StringParser.isDouble(string2);
    }

    public static boolean isValueWithUnit(@Nullable String string) {
        return CSSNumberHelper.isValueWithUnit(string, true);
    }

    public static boolean isValueWithUnit(@Nullable String string, boolean bl) {
        return CSSNumberHelper.getValueWithUnit(string, bl) != null;
    }

    @Nullable
    public static CSSSimpleValueWithUnit getValueWithUnit(@Nullable String string) {
        return CSSNumberHelper.getValueWithUnit(string, true);
    }

    @Nullable
    public static CSSSimpleValueWithUnit getValueWithUnit(@Nullable String string, boolean bl) {
        String string2 = StringHelper.trim(string);
        if (StringHelper.hasText(string2)) {
            BigDecimal bigDecimal;
            ECSSUnit eCSSUnit;
            if (string2.equals("0")) {
                return new CSSSimpleValueWithUnit(BigDecimal.ZERO, ECSSUnit.PX);
            }
            ECSSUnit eCSSUnit2 = eCSSUnit = bl ? CSSNumberHelper.getMatchingUnitInclPercentage(string2) : CSSNumberHelper.getMatchingUnitExclPercentage(string2);
            if (eCSSUnit != null && (bigDecimal = StringParser.parseBigDecimal(string2 = string2.substring(0, string2.length() - eCSSUnit.getName().length()).trim())) != null) {
                return new CSSSimpleValueWithUnit(bigDecimal, eCSSUnit);
            }
        }
        return null;
    }

    static {
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        for (ECSSUnit eCSSUnit : ECSSUnit.values()) {
            commonsHashMap.put(eCSSUnit.getName(), eCSSUnit);
        }
        s_aNameToUnitMap = commonsHashMap.getSortedByKey(IComparator.getComparatorStringLongestFirst());
        INSTANCE = new CSSNumberHelper();
    }
}

