/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.writer;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.css.ECSSVersion;
import saoui.shade.com.helger.css.decl.CascadingStyleSheet;
import saoui.shade.com.helger.css.reader.CSSReader;
import saoui.shade.com.helger.css.writer.CSSWriter;
import saoui.shade.com.helger.css.writer.CSSWriterSettings;
import saoui.shade.org.slf4j.Logger;
import saoui.shade.org.slf4j.LoggerFactory;

@Immutable
public final class CSSCompressor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSSCompressor.class);
    private static final CSSCompressor INSTANCE = new CSSCompressor();

    private CSSCompressor() {
    }

    @Nonnull
    public static String getCompressedCSS(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        return CSSCompressor.getCompressedCSS(string, eCSSVersion, false);
    }

    @Nonnull
    public static String getCompressedCSS(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion, boolean bl) {
        CSSWriterSettings cSSWriterSettings = new CSSWriterSettings(eCSSVersion, true);
        cSSWriterSettings.setRemoveUnnecessaryCode(bl);
        return CSSCompressor.getRewrittenCSS(string, cSSWriterSettings);
    }

    @Nonnull
    public static String getRewrittenCSS(@Nonnull String string, @Nonnull CSSWriterSettings cSSWriterSettings) {
        ValueEnforcer.notNull(string, "OriginalCSS");
        ValueEnforcer.notNull(cSSWriterSettings, "Settings");
        CascadingStyleSheet cascadingStyleSheet = CSSReader.readFromString(string, cSSWriterSettings.getCSSVersion());
        if (cascadingStyleSheet != null) {
            try {
                return new CSSWriter(cSSWriterSettings).getCSSAsString(cascadingStyleSheet);
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to write optimized CSS!", exception);
            }
        }
        return string;
    }
}

