/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.css.writer;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableObject;
import saoui.shade.com.helger.commons.collection.impl.ICommonsList;
import saoui.shade.com.helger.commons.io.stream.NonBlockingStringWriter;
import saoui.shade.com.helger.commons.io.stream.StreamHelper;
import saoui.shade.com.helger.commons.string.StringHelper;
import saoui.shade.com.helger.css.ECSSVersion;
import saoui.shade.com.helger.css.ICSSWriteable;
import saoui.shade.com.helger.css.decl.CSSImportRule;
import saoui.shade.com.helger.css.decl.CSSNamespaceRule;
import saoui.shade.com.helger.css.decl.CascadingStyleSheet;
import saoui.shade.com.helger.css.decl.ICSSTopLevelRule;
import saoui.shade.com.helger.css.writer.CSSWriterSettings;

@NotThreadSafe
public class CSSWriter {
    public static final boolean DEFAULT_OPTIMIZED_OUTPUT = false;
    private final CSSWriterSettings m_aSettings;
    private boolean m_bWriteHeaderText;
    private String m_sHeaderText = "THIS FILE IS GENERATED - DO NOT EDIT";
    private boolean m_bWriteFooterText;
    private String m_sFooterText;
    private String m_sContentCharset;

    public CSSWriter() {
        this(new CSSWriterSettings());
    }

    public CSSWriter(@Nonnull ECSSVersion eCSSVersion) {
        this(eCSSVersion, false);
    }

    public CSSWriter(@Nonnull ECSSVersion eCSSVersion, boolean bl) {
        this(new CSSWriterSettings(eCSSVersion, bl));
    }

    public CSSWriter(@Nonnull CSSWriterSettings cSSWriterSettings) {
        ValueEnforcer.notNull(cSSWriterSettings, "Settings");
        this.m_aSettings = cSSWriterSettings;
        this.m_bWriteHeaderText = !cSSWriterSettings.isOptimizedOutput();
        this.m_bWriteFooterText = !cSSWriterSettings.isOptimizedOutput();
    }

    public boolean isWriteHeaderText() {
        return this.m_bWriteHeaderText;
    }

    @Nonnull
    public CSSWriter setWriteHeaderText(boolean bl) {
        this.m_bWriteHeaderText = bl;
        return this;
    }

    @Nullable
    public String getHeaderText() {
        return this.m_sHeaderText;
    }

    @Nonnull
    public CSSWriter setHeaderText(@Nullable String string) {
        this.m_sHeaderText = string;
        return this;
    }

    public boolean isWriteFooterText() {
        return this.m_bWriteFooterText;
    }

    @Nonnull
    public CSSWriter setWriteFooterText(boolean bl) {
        this.m_bWriteFooterText = bl;
        return this;
    }

    @Nullable
    public String getFooterText() {
        return this.m_sFooterText;
    }

    @Nonnull
    public CSSWriter setFooterText(@Nullable String string) {
        this.m_sFooterText = string;
        return this;
    }

    @Nullable
    public String getContentCharset() {
        return this.m_sContentCharset;
    }

    @Nonnull
    public CSSWriter setContentCharset(@Nullable String string) {
        this.m_sContentCharset = string;
        return this;
    }

    @Nonnull
    @ReturnsMutableObject(value="Design")
    public CSSWriterSettings getSettings() {
        return this.m_aSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCSS(@Nonnull CascadingStyleSheet cascadingStyleSheet, @Nonnull @WillClose Writer writer) throws IOException {
        ValueEnforcer.notNull(cascadingStyleSheet, "CSS");
        ValueEnforcer.notNull(writer, "Writer");
        try {
            Iterator iterator;
            Object object;
            boolean bl = this.m_aSettings.isOptimizedOutput();
            String string = this.m_aSettings.getNewLineString();
            if (this.m_bWriteHeaderText && StringHelper.hasText(this.m_sHeaderText)) {
                writer.write("/*");
                writer.write(string);
                for (String iCommonsList2 : StringHelper.getExploded("\n", this.m_sHeaderText)) {
                    writer.write(" * " + iCommonsList2);
                    writer.write(string);
                }
                writer.write(" */");
                writer.write(string);
            }
            if (StringHelper.hasText(this.m_sContentCharset)) {
                writer.write("@charset \"" + this.m_sContentCharset + "\";");
                if (!bl) {
                    writer.write(string);
                }
            }
            int n = 0;
            ICommonsList<CSSImportRule> iCommonsList = cascadingStyleSheet.getAllImportRules();
            if (iCommonsList.isNotEmpty()) {
                object = iCommonsList.iterator();
                while (object.hasNext()) {
                    iterator = (CSSImportRule)object.next();
                    writer.write(iterator.getAsCSSString(this.m_aSettings));
                    ++n;
                }
            }
            if ((object = cascadingStyleSheet.getAllNamespaceRules()).isNotEmpty()) {
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    CSSNamespaceRule cSSNamespaceRule = (CSSNamespaceRule)iterator.next();
                    writer.write(cSSNamespaceRule.getAsCSSString(this.m_aSettings));
                    ++n;
                }
            }
            for (ICSSTopLevelRule iCSSTopLevelRule : cascadingStyleSheet.getAllRules()) {
                String string2 = iCSSTopLevelRule.getAsCSSString(this.m_aSettings);
                if (!StringHelper.hasText(string2)) continue;
                if (!bl && n > 0) {
                    writer.write(string);
                }
                writer.write(string2);
                ++n;
            }
            if (this.m_bWriteFooterText && StringHelper.hasText(this.m_sFooterText)) {
                writer.write("/*");
                writer.write(string);
                for (String string3 : StringHelper.getExploded('\n', this.m_sFooterText)) {
                    writer.write(" * " + string3);
                    writer.write(string);
                }
                writer.write(" */");
                writer.write(string);
            }
        }
        finally {
            StreamHelper.close(writer);
        }
    }

    @Nonnull
    public String getCSSAsString(@Nonnull CascadingStyleSheet cascadingStyleSheet) {
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter();
        try {
            this.writeCSS(cascadingStyleSheet, (Writer)nonBlockingStringWriter);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Totally unexpected", iOException);
        }
        return nonBlockingStringWriter.getAsString();
    }

    public void writeCSS(@Nonnull ICSSWriteable iCSSWriteable, @Nonnull @WillClose Writer writer) throws IOException {
        ValueEnforcer.notNull(iCSSWriteable, "CSS");
        ValueEnforcer.notNull(writer, "Writer");
        try {
            writer.write(iCSSWriteable.getAsCSSString(this.m_aSettings));
        }
        finally {
            StreamHelper.close(writer);
        }
    }

    @Nonnull
    public String getCSSAsString(@Nonnull ICSSWriteable iCSSWriteable) {
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter();
        try {
            this.writeCSS(iCSSWriteable, (Writer)nonBlockingStringWriter);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Totally unexpected", iOException);
        }
        return nonBlockingStringWriter.getAsString();
    }
}

