/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.entity.EntityTFAdherent;
import twilightforest.entity.EntityTFArmoredGiant;
import twilightforest.entity.EntityTFBlockGoblin;
import twilightforest.entity.EntityTFDeathTome;
import twilightforest.entity.EntityTFFireBeetle;
import twilightforest.entity.EntityTFGiantMiner;
import twilightforest.entity.EntityTFGoblinKnightLower;
import twilightforest.entity.EntityTFHarbingerCube;
import twilightforest.entity.EntityTFHelmetCrab;
import twilightforest.entity.EntityTFIceExploder;
import twilightforest.entity.EntityTFIceShooter;
import twilightforest.entity.EntityTFKobold;
import twilightforest.entity.EntityTFMazeSlime;
import twilightforest.entity.EntityTFMiniGhast;
import twilightforest.entity.EntityTFMinotaur;
import twilightforest.entity.EntityTFPinchBeetle;
import twilightforest.entity.EntityTFRedcap;
import twilightforest.entity.EntityTFRedcapSapper;
import twilightforest.entity.EntityTFSlimeBeetle;
import twilightforest.entity.EntityTFSnowGuardian;
import twilightforest.entity.EntityTFSwarmSpider;
import twilightforest.entity.EntityTFTowerBroodling;
import twilightforest.entity.EntityTFTowerGhast;
import twilightforest.entity.EntityTFTowerGolem;
import twilightforest.entity.EntityTFTroll;
import twilightforest.entity.EntityTFWraith;
import twilightforest.entity.EntityTFYeti;
import twilightforest.structures.ComponentTFHedgeMaze;
import twilightforest.structures.ComponentTFHollowHill;
import twilightforest.structures.ComponentTFHydraLair;
import twilightforest.structures.ComponentTFQuestGrove;
import twilightforest.structures.ComponentTFYetiCave;
import twilightforest.structures.courtyard.NagaCourtyardPieces;
import twilightforest.structures.darktower.TFDarkTowerPieces;
import twilightforest.structures.finalcastle.TFFinalCastlePieces;
import twilightforest.structures.icetower.TFIceTowerPieces;
import twilightforest.structures.lichtower.TFLichTowerPieces;
import twilightforest.structures.minotaurmaze.TFMinotaurMazePieces;
import twilightforest.structures.mushroomtower.TFMushroomTowerPieces;
import twilightforest.structures.start.StructureStartAuroraPalace;
import twilightforest.structures.start.StructureStartCourtyard;
import twilightforest.structures.start.StructureStartDarkTower;
import twilightforest.structures.start.StructureStartFinalCastle;
import twilightforest.structures.start.StructureStartHedgeMaze;
import twilightforest.structures.start.StructureStartHollowHill;
import twilightforest.structures.start.StructureStartHydraLair;
import twilightforest.structures.start.StructureStartKnightStronghold;
import twilightforest.structures.start.StructureStartLabyrinth;
import twilightforest.structures.start.StructureStartLichTower;
import twilightforest.structures.start.StructureStartMushroomTower;
import twilightforest.structures.start.StructureStartNothing;
import twilightforest.structures.start.StructureStartQuestGrove;
import twilightforest.structures.start.StructureStartTFAbstract;
import twilightforest.structures.start.StructureStartTrollCave;
import twilightforest.structures.start.StructureStartYetiCave;
import twilightforest.structures.stronghold.TFStrongholdPieces;
import twilightforest.structures.trollcave.TFTrollCavePieces;
import twilightforest.util.IntPair;
import twilightforest.util.PlayerHelper;
import twilightforest.world.MapGenTFMajorFeature;

public enum TFFeature {
    NOTHING(0, "no_feature", false, new ResourceLocation[0]){
        {
            this.enableDecorations().disableStructure();
        }
    }
    ,
    SMALL_HILL(1, "small_hollow_hill", true, new ResourceLocation[0]){
        {
            this.enableDecorations().enableTerrainAlterations();
            MapGenStructureIO.func_143034_b(StructureStartHollowHill.class, (String)"TFHill");
            MapGenStructureIO.func_143031_a(ComponentTFHollowHill.class, (String)"TFHill");
            this.addMonster(EntitySpider.class, 10, 4, 4).addMonster(EntityZombie.class, 10, 4, 4).addMonster(EntityTFRedcap.class, 10, 4, 4).addMonster(EntityTFSwarmSpider.class, 10, 4, 4).addMonster(EntityTFKobold.class, 10, 4, 8);
        }

        @Override
        public StructureStartTFAbstract provideStructureStart(World world, Random rand, int chunkX, int chunkZ) {
            return new StructureStartHollowHill(world, this, rand, chunkX, chunkZ);
        }
    }
    ,
    MEDIUM_HILL(2, "medium_hollow_hill", true, new ResourceLocation[0]){
        {
            this.enableDecorations().enableTerrainAlterations();
            this.addMonster(EntityTFRedcap.class, 10, 4, 4).addMonster(EntityTFRedcapSapper.class, 1, 1, 4).addMonster(EntityTFKobold.class, 10, 4, 8).addMonster(EntitySkeleton.class, 10, 4, 4).addMonster(EntityTFSwarmSpider.class, 10, 4, 4).addMonster(EntitySpider.class, 10, 4, 4).addMonster(EntityCreeper.class, 10, 4, 4).addMonster(EntityTFFireBeetle.class, 5, 4, 4).addMonster(EntityTFSlimeBeetle.class, 5, 4, 4).addMonster(EntityWitch.class, 1, 1, 1);
        }

        @Override
        public StructureStartTFAbstract provideStructureStart(World world, Random rand, int chunkX, int chunkZ) {
            return new StructureStartHollowHill(world, this, rand, chunkX, chunkZ);
        }
    }
    ,
    LARGE_HILL(3, "large_hollow_hill", true, new ResourceLocation[0]){
        {
            this.enableDecorations().enableTerrainAlterations();
            this.addMonster(EntityTFRedcap.class, 10, 4, 4).addMonster(EntityTFRedcapSapper.class, 2, 1, 4).addMonster(EntitySkeleton.class, 10, 4, 4).addMonster(EntityCaveSpider.class, 10, 4, 4).addMonster(EntityCreeper.class, 10, 4, 4).addMonster(EntityEnderman.class, 1, 1, 4).addMonster(EntityTFWraith.class, 2, 1, 4).addMonster(EntityTFFireBeetle.class, 10, 4, 4).addMonster(EntityTFSlimeBeetle.class, 10, 4, 4).addMonster(EntityTFPinchBeetle.class, 10, 2, 4).addMonster(EntityWitch.class, 1, 1, 1);
        }

        @Override
        public StructureStartTFAbstract provideStructureStart(World world, Random rand, int chunkX, int chunkZ) {
            return new StructureStartHollowHill(world, this, rand, chunkX, chunkZ);
        }
    }
    ,
    HEDGE_MAZE(2, "hedge_maze", true, new ResourceLocation[0]){
        {
            this.enableTerrainAlterations();
            MapGenStructureIO.func_143034_b(StructureStartHedgeMaze.class, (String)"TFHedge");
            MapGenStructureIO.func_143031_a(ComponentTFHedgeMaze.class, (String)"TFHedge");
        }

        @Override
        public StructureStartTFAbstract provideStructureStart(World world, Random rand, int chunkX, int chunkZ) {
            return new StructureStartHedgeMaze(world, this, rand, chunkX, chunkZ);
        }
    }
    ,
    NAGA_COURTYARD(3, "naga_courtyard", true, new ResourceLocation[0]){
        {
            this.enableTerrainAlterations();
            NagaCourtyardPieces.registerPieces();
        }

        @Override
        public StructureStartTFAbstract provideStructureStart(World world, Random rand, int chunkX, int chunkZ) {
            return new StructureStartCourtyard(world, this, rand, chunkX, chunkZ);
        }
    }
    ,
    LICH_TOWER(1, "lich_tower", true, new ResourceLocation[]{TwilightForestMod.prefix("progress_naga")}){
        {
            TFLichTowerPieces.registerPieces();
            this.addMonster(EntityZombie.class, 10, 4, 4).addMonster(EntitySkeleton.class, 10, 4, 4).addMonster(EntityCreeper.class, 1, 4, 4).addMonster(EntityEnderman.class, 1, 1, 4).addMonster(EntityTFDeathTome.class, 10, 4, 4).addMonster(EntityWitch.class, 1, 1, 1);
        }

        @Override
        protected void addBookInformation(ItemStack book, NBTTagList bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.lichtower", 4);
            book.func_77983_a("pages", (NBTBase)bookPages);
            book.func_77983_a("author", (NBTBase)new NBTTagString(TFFeature.BOOK_AUTHOR));
            book.func_77983_a("title", (NBTBase)new NBTTagString("Notes on a Pointy Tower"));
        }

        @Override
        public StructureStartTFAbstract provideStructureStart(World world, Random rand, int chunkX, int chunkZ) {
            return new StructureStartLichTower(world, this, rand, chunkX, chunkZ);
        }
    }
    ,
    ICE_TOWER(2, "ice_tower", true, new ResourceLocation[]{TwilightForestMod.prefix("progress_yeti")}){
        {
            TFIceTowerPieces.registerPieces();
            this.addMonster(EntityTFSnowGuardian.class, 10, 4, 4).addMonster(EntityTFIceShooter.class, 10, 4, 4).addMonster(EntityTFIceExploder.class, 5, 4, 4);
        }

        @Override
        protected void addBookInformation(ItemStack book, NBTTagList bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.icetower", 3);
            book.func_77983_a("pages", (NBTBase)bookPages);
            book.func_77983_a("author", (NBTBase)new NBTTagString(TFFeature.BOOK_AUTHOR));
            book.func_77983_a("title", (NBTBase)new NBTTagString("Notes on Auroral Fortification"));
        }

        @Override
        public StructureStartTFAbstract provideStructureStart(World world, Random rand, int chunkX, int chunkZ) {
            return new StructureStartAuroraPalace(world, this, rand, chunkX, chunkZ);
        }
    }
    ,
    QUEST_ISLAND(1, "quest_island", false, new ResourceLocation[0]){
        {
            this.disableStructure();
        }
    }
    ,
    QUEST_GROVE(1, "quest_grove", true, new ResourceLocation[0]){
        {
            this.enableTerrainAlterations();
            MapGenStructureIO.func_143034_b(StructureStartQuestGrove.class, (String)"TFQuest1");
            MapGenStructureIO.func_143031_a(ComponentTFQuestGrove.class, (String)"TFQuest1");
        }

        @Override
        public StructureStartTFAbstract provideStructureStart(World world, Random rand, int chunkX, int chunkZ) {
            return new StructureStartQuestGrove(world, this, rand, chunkX, chunkZ);
        }
    }
    ,
    DRUID_GROVE(1, "druid_grove", false, new ResourceLocation[0]){
        {
            this.disableStructure();
        }
    }
    ,
    FLOATING_RUINS(3, "floating_ruins", false, new ResourceLocation[0]){
        {
            this.disableStructure();
        }
    }
    ,
    HYDRA_LAIR(2, "hydra_lair", true, new ResourceLocation[]{TwilightForestMod.prefix("progress_labyrinth")}){
        {
            this.enableTerrainAlterations();
            MapGenStructureIO.func_143034_b(StructureStartHydraLair.class, (String)"TFHydra");
            MapGenStructureIO.func_143031_a(ComponentTFHydraLair.class, (String)"TFHydra");
        }

        @Override
        protected void addBookInformation(ItemStack book, NBTTagList bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.hydralair", 4);
            book.func_77983_a("pages", (NBTBase)bookPages);
            book.func_77983_a("author", (NBTBase)new NBTTagString(TFFeature.BOOK_AUTHOR));
            book.func_77983_a("title", (NBTBase)new NBTTagString("Notes on the Fire Swamp"));
        }

        @Override
        public StructureStartTFAbstract provideStructureStart(World world, Random rand, int chunkX, int chunkZ) {
            return new StructureStartHydraLair(world, this, rand, chunkX, chunkZ);
        }
    }
    ,
    LABYRINTH(3, "labyrinth", true, new ResourceLocation[]{TwilightForestMod.prefix("progress_lich")}){
        {
            this.enableDecorations();
            TFMinotaurMazePieces.registerPieces();
            this.addMonster(EntityTFMinotaur.class, 20, 2, 4).addMonster(EntityCaveSpider.class, 10, 4, 4).addMonster(EntityCreeper.class, 10, 4, 4).addMonster(EntityTFMazeSlime.class, 10, 4, 4).addMonster(EntityEnderman.class, 1, 1, 4).addMonster(EntityTFFireBeetle.class, 10, 4, 4).addMonster(EntityTFSlimeBeetle.class, 10, 4, 4).addMonster(EntityTFPinchBeetle.class, 10, 2, 4);
        }

        @Override
        protected void addBookInformation(ItemStack book, NBTTagList bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.labyrinth", 5);
            book.func_77983_a("pages", (NBTBase)bookPages);
            book.func_77983_a("author", (NBTBase)new NBTTagString(TFFeature.BOOK_AUTHOR));
            book.func_77983_a("title", (NBTBase)new NBTTagString("Notes on a Swampy Labyrinth"));
        }

        @Override
        public StructureStartTFAbstract provideStructureStart(World world, Random rand, int chunkX, int chunkZ) {
            return new StructureStartLabyrinth(world, this, rand, chunkX, chunkZ);
        }
    }
    ,
    DARK_TOWER(1, "dark_tower", true, new ResourceLocation[]{TwilightForestMod.prefix("progress_knights")}){
        {
            TFDarkTowerPieces.registerPieces();
            this.addMonster(EntityTFTowerGolem.class, 10, 4, 4).addMonster(EntitySkeleton.class, 10, 4, 4).addMonster(EntityCreeper.class, 10, 4, 4).addMonster(EntityEnderman.class, 2, 1, 4).addMonster(EntityWitch.class, 1, 1, 1).addMonster(EntityTFMiniGhast.class, 10, 1, 4).addMonster(EntityTFTowerBroodling.class, 10, 8, 8).addMonster(EntityTFPinchBeetle.class, 10, 2, 4).addMonster(1, EntityTFTowerGhast.class, 10, 1, 4).addWaterCreature(EntitySquid.class, 10, 4, 4);
        }

        @Override
        protected void addBookInformation(ItemStack book, NBTTagList bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.darktower", 3);
            book.func_77983_a("pages", (NBTBase)bookPages);
            book.func_77983_a("author", (NBTBase)new NBTTagString(TFFeature.BOOK_AUTHOR));
            book.func_77983_a("title", (NBTBase)new NBTTagString("Notes on a Wooden Tower"));
        }

        @Override
        public StructureStartTFAbstract provideStructureStart(World world, Random rand, int chunkX, int chunkZ) {
            return new StructureStartDarkTower(world, this, rand, chunkX, chunkZ);
        }
    }
    ,
    KNIGHT_STRONGHOLD(3, "knight_stronghold", true, new ResourceLocation[]{TwilightForestMod.prefix("progress_trophy_pedestal")}){
        {
            this.enableDecorations().disableProtectionAura();
            TFStrongholdPieces.registerPieces();
            this.addMonster(EntityTFBlockGoblin.class, 10, 4, 4).addMonster(EntityTFGoblinKnightLower.class, 5, 1, 2).addMonster(EntityTFHelmetCrab.class, 10, 4, 4).addMonster(EntityTFSlimeBeetle.class, 10, 4, 4).addMonster(EntityTFRedcapSapper.class, 2, 1, 4).addMonster(EntityTFKobold.class, 10, 4, 8).addMonster(EntityCreeper.class, 10, 4, 4).addMonster(EntitySlime.class, 5, 4, 4);
        }

        @Override
        protected void addBookInformation(ItemStack book, NBTTagList bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.tfstronghold", 5);
            book.func_77983_a("pages", (NBTBase)bookPages);
            book.func_77983_a("author", (NBTBase)new NBTTagString(TFFeature.BOOK_AUTHOR));
            book.func_77983_a("title", (NBTBase)new NBTTagString("Notes on a Stronghold"));
        }

        @Override
        public StructureStartTFAbstract provideStructureStart(World world, Random rand, int chunkX, int chunkZ) {
            return new StructureStartKnightStronghold(world, this, rand, chunkX, chunkZ);
        }
    }
    ,
    WORLD_TREE(3, "world_tree", false, new ResourceLocation[0]){
        {
            this.disableStructure();
        }
    }
    ,
    YETI_CAVE(2, "yeti_lairs", true, new ResourceLocation[]{TwilightForestMod.prefix("progress_lich")}){
        {
            this.enableDecorations().enableTerrainAlterations();
            MapGenStructureIO.func_143034_b(StructureStartYetiCave.class, (String)"TFYeti");
            MapGenStructureIO.func_143031_a(ComponentTFYetiCave.class, (String)"TFYeti");
            this.addMonster(EntityTFYeti.class, 10, 4, 4);
        }

        @Override
        protected void addBookInformation(ItemStack book, NBTTagList bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.yeticave", 3);
            book.func_77983_a("pages", (NBTBase)bookPages);
            book.func_77983_a("author", (NBTBase)new NBTTagString(TFFeature.BOOK_AUTHOR));
            book.func_77983_a("title", (NBTBase)new NBTTagString("Notes on an Icy Cave"));
        }

        @Override
        public StructureStartTFAbstract provideStructureStart(World world, Random rand, int chunkX, int chunkZ) {
            return new StructureStartYetiCave(world, this, rand, chunkX, chunkZ);
        }
    }
    ,
    TROLL_CAVE(4, "troll_lairs", true, new ResourceLocation[]{TwilightForestMod.prefix("progress_merge")}){
        {
            this.enableDecorations().enableTerrainAlterations().disableProtectionAura();
            TFTrollCavePieces.registerPieces();
            this.addMonster(EntityCreeper.class, 5, 4, 4).addMonster(EntitySkeleton.class, 10, 4, 4).addMonster(EntityTFTroll.class, 20, 4, 4).addMonster(EntityWitch.class, 5, 1, 1).addMonster(1, EntityTFGiantMiner.class, 10, 1, 4).addMonster(1, EntityTFArmoredGiant.class, 10, 1, 4);
        }

        @Override
        protected void addBookInformation(ItemStack book, NBTTagList bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.trollcave", 3);
            book.func_77983_a("pages", (NBTBase)bookPages);
            book.func_77983_a("author", (NBTBase)new NBTTagString(TFFeature.BOOK_AUTHOR));
            book.func_77983_a("title", (NBTBase)new NBTTagString("Notes on the Highlands"));
        }

        @Override
        public StructureStartTFAbstract provideStructureStart(World world, Random rand, int chunkX, int chunkZ) {
            return new StructureStartTrollCave(world, this, rand, chunkX, chunkZ);
        }
    }
    ,
    FINAL_CASTLE(4, "final_castle", true, new ResourceLocation[]{TwilightForestMod.prefix("progress_troll")}){
        {
            TFFinalCastlePieces.registerFinalCastlePieces();
            this.addMonster(EntityTFKobold.class, 10, 4, 4).addMonster(EntityTFAdherent.class, 10, 1, 1).addMonster(EntityTFHarbingerCube.class, 10, 1, 1).addMonster(EntityEnderman.class, 10, 1, 1).addMonster(1, EntityTFKobold.class, 10, 4, 4).addMonster(1, EntityTFAdherent.class, 10, 1, 1).addMonster(1, EntityTFHarbingerCube.class, 10, 1, 1).addMonster(1, EntityTFArmoredGiant.class, 10, 1, 1).addMonster(2, EntityTFAdherent.class, 10, 1, 1).addMonster(3, EntityBlaze.class, 10, 1, 1);
        }

        @Override
        public StructureStartTFAbstract provideStructureStart(World world, Random rand, int chunkX, int chunkZ) {
            return new StructureStartFinalCastle(world, this, rand, chunkX, chunkZ);
        }
    }
    ,
    MUSHROOM_TOWER(2, "mushroom_tower", true, new ResourceLocation[0]){
        {
            TFMushroomTowerPieces.registerPieces();
        }

        @Override
        public StructureStartTFAbstract provideStructureStart(World world, Random rand, int chunkX, int chunkZ) {
            return new StructureStartMushroomTower(world, this, rand, chunkX, chunkZ);
        }
    };

    public final int size;
    public final String name;
    private final boolean shouldHaveFeatureGenerator;
    public boolean areChunkDecorationsEnabled;
    public boolean isStructureEnabled;
    public boolean isTerrainAltered;
    private List<List<Biome.SpawnListEntry>> spawnableMonsterLists;
    private List<Biome.SpawnListEntry> ambientCreatureList;
    private List<Biome.SpawnListEntry> waterCreatureList;
    private final ResourceLocation[] requiredAdvancements;
    public boolean hasProtectionAura;
    private long lastSpawnedHintMonsterTime;
    private static final String BOOK_AUTHOR = "A Forgotten Explorer";
    private static final TFFeature[] VALUES;
    private static final int maxSize;

    private TFFeature(int size, String name, boolean featureGenerator, ResourceLocation ... requiredAdvancements) {
        this.size = size;
        this.name = name;
        this.areChunkDecorationsEnabled = false;
        this.isStructureEnabled = true;
        this.isTerrainAltered = false;
        this.spawnableMonsterLists = new ArrayList<List<Biome.SpawnListEntry>>();
        this.ambientCreatureList = new ArrayList<Biome.SpawnListEntry>();
        this.waterCreatureList = new ArrayList<Biome.SpawnListEntry>();
        this.hasProtectionAura = true;
        this.ambientCreatureList.add(new Biome.SpawnListEntry(EntityBat.class, 10, 8, 8));
        this.requiredAdvancements = requiredAdvancements;
        this.shouldHaveFeatureGenerator = featureGenerator;
    }

    static void init() {
    }

    public static int getCount() {
        return VALUES.length;
    }

    public static int getMaxSize() {
        return maxSize;
    }

    @Nullable
    public MapGenTFMajorFeature createFeatureGenerator() {
        return this.shouldHaveFeatureGenerator ? new MapGenTFMajorFeature(this) : null;
    }

    public static TFFeature getFeatureByName(String name) {
        for (TFFeature feature : VALUES) {
            if (!feature.name.equalsIgnoreCase(name)) continue;
            return feature;
        }
        return NOTHING;
    }

    public static TFFeature getFeatureByName(ResourceLocation name) {
        if (name.func_110624_b().equalsIgnoreCase("twilightforest")) {
            return TFFeature.getFeatureByName(name.func_110623_a());
        }
        return NOTHING;
    }

    public static TFFeature getFeatureByID(int id) {
        return id < VALUES.length ? VALUES[id] : NOTHING;
    }

    public static int getFeatureID(int mapX, int mapZ, World world) {
        return TFFeature.getFeatureAt(mapX, mapZ, world).ordinal();
    }

    public static TFFeature getFeatureAt(int mapX, int mapZ, World world) {
        return TFFeature.generateFeature(mapX >> 4, mapZ >> 4, world);
    }

    public static boolean isInFeatureChunk(World world, int mapX, int mapZ) {
        int chunkX = mapX >> 4;
        int chunkZ = mapZ >> 4;
        BlockPos cc = TFFeature.getNearestCenterXYZ(chunkX, chunkZ, world);
        return chunkX == cc.func_177958_n() >> 4 && chunkZ == cc.func_177952_p() >> 4;
    }

    public TFFeature enableDecorations() {
        this.areChunkDecorationsEnabled = true;
        return this;
    }

    public TFFeature disableStructure() {
        this.isStructureEnabled = false;
        return this;
    }

    public TFFeature enableTerrainAlterations() {
        this.isTerrainAltered = true;
        return this;
    }

    public TFFeature disableProtectionAura() {
        this.hasProtectionAura = false;
        return this;
    }

    public TFFeature addMonster(Class<? extends EntityLiving> monsterClass, int weight, int minGroup, int maxGroup) {
        this.addMonster(0, monsterClass, weight, minGroup, maxGroup);
        return this;
    }

    public TFFeature addMonster(int listIndex, Class<? extends EntityLiving> monsterClass, int weight, int minGroup, int maxGroup) {
        List<Object> monsterList;
        if (this.spawnableMonsterLists.size() > listIndex) {
            monsterList = this.spawnableMonsterLists.get(listIndex);
        } else {
            monsterList = new ArrayList();
            this.spawnableMonsterLists.add(listIndex, monsterList);
        }
        monsterList.add(new Biome.SpawnListEntry(monsterClass, weight, minGroup, maxGroup));
        return this;
    }

    public TFFeature addWaterCreature(Class<? extends EntityLiving> monsterClass, int weight, int minGroup, int maxGroup) {
        this.waterCreatureList.add(new Biome.SpawnListEntry(monsterClass, weight, minGroup, maxGroup));
        return this;
    }

    public static TFFeature getFeatureDirectlyAt(int chunkX, int chunkZ, World world) {
        if (TFFeature.isInFeatureChunk(world, chunkX << 4, chunkZ << 4)) {
            return TFFeature.getFeatureAt(chunkX << 4, chunkZ << 4, world);
        }
        return NOTHING;
    }

    public static TFFeature generateFeature(int chunkX, int chunkZ, World world) {
        TFFeature biomeFeature;
        Biome biomeAt = world.func_180494_b(new BlockPos(((chunkX = Math.round((float)chunkX / 16.0f) * 16) << 4) + 8, 0, ((chunkZ = Math.round((float)chunkZ / 16.0f) * 16) << 4) + 8));
        if (biomeAt instanceof TFBiomeBase && (biomeFeature = ((TFBiomeBase)biomeAt).containedFeature) != NOTHING) {
            return biomeFeature;
        }
        int regionOffsetX = Math.abs((chunkX + 64 >> 4) % 8);
        int regionOffsetZ = Math.abs((chunkZ + 64 >> 4) % 8);
        if (regionOffsetX == 4 && regionOffsetZ == 5 || regionOffsetX == 4 && regionOffsetZ == 3) {
            return LICH_TOWER;
        }
        if (regionOffsetX == 5 && regionOffsetZ == 4 || regionOffsetX == 3 && regionOffsetZ == 4) {
            return NAGA_COURTYARD;
        }
        switch (new Random(world.func_72905_C() + (long)(chunkX * 25117) + (long)(chunkZ * 151121)).nextInt(16)) {
            default: {
                return SMALL_HILL;
            }
            case 6: 
            case 7: 
            case 8: {
                return MEDIUM_HILL;
            }
            case 9: {
                return LARGE_HILL;
            }
            case 10: 
            case 11: {
                return HEDGE_MAZE;
            }
            case 12: 
            case 13: {
                return NAGA_COURTYARD;
            }
            case 14: 
            case 15: 
        }
        return LICH_TOWER;
    }

    public static TFFeature getNearestFeature(int cx, int cz, World world) {
        return TFFeature.getNearestFeature(cx, cz, world, null);
    }

    public static TFFeature getNearestFeature(int cx, int cz, World world, @Nullable IntPair center) {
        int diam = maxSize * 2 + 1;
        TFFeature[] features = new TFFeature[diam * diam];
        for (int rad = 1; rad <= maxSize; ++rad) {
            for (int x = -rad; x <= rad; ++x) {
                for (int z = -rad; z <= rad; ++z) {
                    int idx = (x + maxSize) * diam + (z + maxSize);
                    TFFeature directlyAt = features[idx];
                    if (directlyAt == null) {
                        features[idx] = directlyAt = TFFeature.getFeatureDirectlyAt(x + cx, z + cz, world);
                    }
                    if (directlyAt.size != rad) continue;
                    if (center != null) {
                        center.x = (x << 4) + 8;
                        center.z = (z << 4) + 8;
                    }
                    return directlyAt;
                }
            }
        }
        return NOTHING;
    }

    @Nullable
    public static BlockPos findNearestFeaturePosBySpacing(World worldIn, TFFeature feature, BlockPos blockPos, int p_191069_3_, int p_191069_4_, int p_191069_5_, boolean p_191069_6_, int p_191069_7_, boolean findUnexplored) {
        int i = blockPos.func_177958_n() >> 4;
        int j = blockPos.func_177952_p() >> 4;
        Random random = new Random();
        block0: for (int k = 0; k <= p_191069_7_; ++k) {
            for (int l = -k; l <= k; ++l) {
                boolean flag = l == -k || l == k;
                for (int i1 = -k; i1 <= k; ++i1) {
                    boolean flag1;
                    boolean bl = flag1 = i1 == -k || i1 == k;
                    if (!flag && !flag1) continue;
                    int j1 = i + p_191069_3_ * l;
                    int k1 = j + p_191069_3_ * i1;
                    if (j1 < 0) {
                        j1 -= p_191069_3_ - 1;
                    }
                    if (k1 < 0) {
                        k1 -= p_191069_3_ - 1;
                    }
                    int l1 = j1 / p_191069_3_;
                    int i2 = k1 / p_191069_3_;
                    Random random1 = worldIn.func_72843_D(l1, i2, p_191069_5_);
                    l1 *= p_191069_3_;
                    i2 *= p_191069_3_;
                    if (p_191069_6_) {
                        l1 += (random1.nextInt(p_191069_3_ - p_191069_4_) + random1.nextInt(p_191069_3_ - p_191069_4_)) / 2;
                        i2 += (random1.nextInt(p_191069_3_ - p_191069_4_) + random1.nextInt(p_191069_3_ - p_191069_4_)) / 2;
                    } else {
                        l1 += random1.nextInt(p_191069_3_ - p_191069_4_);
                        i2 += random1.nextInt(p_191069_3_ - p_191069_4_);
                    }
                    MapGenBase.func_191068_a((long)worldIn.func_72905_C(), (Random)random, (int)l1, (int)i2);
                    random.nextInt();
                    if (TFFeature.getFeatureAt(l1 << 4, i2 << 4, worldIn) == feature) {
                        if (findUnexplored && worldIn.func_190526_b(l1, i2)) continue;
                        return new BlockPos((l1 << 4) + 8, 64, (i2 << 4) + 8);
                    }
                    if (k == 0) break;
                }
                if (k == 0) continue block0;
            }
        }
        return null;
    }

    public static TFFeature getFeatureForRegion(int chunkX, int chunkZ, World world) {
        int featureX = Math.round((float)chunkX / 16.0f) * 16;
        int featureZ = Math.round((float)chunkZ / 16.0f) * 16;
        return TFFeature.generateFeature(featureX, featureZ, world);
    }

    public static TFFeature getFeatureForRegionPos(int posX, int posZ, World world) {
        return TFFeature.getFeatureForRegion(posX >> 4, posZ >> 4, world);
    }

    public static BlockPos getNearestCenterXYZ(int cx, int cz, World world) {
        int regionX = cx + 8 >> 4;
        int regionZ = cz + 8 >> 4;
        long seed = (long)(regionX * 3129871) ^ (long)regionZ * 116129781L;
        seed = seed * seed * 42317861L + seed * 7L;
        int num0 = (int)(seed >> 12 & 3L);
        int num1 = (int)(seed >> 15 & 3L);
        int num2 = (int)(seed >> 18 & 3L);
        int num3 = (int)(seed >> 21 & 3L);
        int centerX = 8 + num0 - num1;
        int centerZ = 8 + num2 - num3;
        int ccz = regionZ >= 0 ? (regionZ * 16 + centerZ - 8) * 16 + 8 : (regionZ * 16 + (16 - centerZ) - 8) * 16 + 9;
        int ccx = regionX >= 0 ? (regionX * 16 + centerX - 8) * 16 + 8 : (regionX * 16 + (16 - centerX) - 8) * 16 + 9;
        return new BlockPos(ccx, 31, ccz);
    }

    public List<Biome.SpawnListEntry> getSpawnableList(EnumCreatureType creatureType) {
        switch (creatureType) {
            case MONSTER: {
                return this.getSpawnableList(EnumCreatureType.MONSTER, 0);
            }
            case AMBIENT: {
                return this.ambientCreatureList;
            }
            case WATER_CREATURE: {
                return this.waterCreatureList;
            }
        }
        return new ArrayList<Biome.SpawnListEntry>();
    }

    public List<Biome.SpawnListEntry> getSpawnableList(EnumCreatureType creatureType, int index) {
        if (creatureType != EnumCreatureType.MONSTER) {
            return this.getSpawnableList(creatureType);
        }
        if (index >= 0 && index < this.spawnableMonsterLists.size()) {
            return this.spawnableMonsterLists.get(index);
        }
        return new ArrayList<Biome.SpawnListEntry>();
    }

    public boolean doesPlayerHaveRequiredAdvancements(EntityPlayer player) {
        return PlayerHelper.doesPlayerHaveRequiredAdvancements(player, this.requiredAdvancements);
    }

    public void trySpawnHintMonster(World world, EntityPlayer player) {
        this.trySpawnHintMonster(world, player, new BlockPos((Entity)player));
    }

    public void trySpawnHintMonster(World world, EntityPlayer player, BlockPos pos) {
        long currentTime = world.func_82737_E();
        if (currentTime < this.lastSpawnedHintMonsterTime) {
            this.lastSpawnedHintMonsterTime = 0L;
        }
        if (currentTime - this.lastSpawnedHintMonsterTime > 1200L) {
            for (int i = 0; i < 20; ++i) {
                if (!this.didSpawnHintMonster(world, player, pos)) continue;
                this.lastSpawnedHintMonsterTime = currentTime;
                break;
            }
        }
    }

    private boolean didSpawnHintMonster(World world, EntityPlayer player, BlockPos pos) {
        int dx = world.field_73012_v.nextInt(16) - world.field_73012_v.nextInt(16);
        int dy = world.field_73012_v.nextInt(4) - world.field_73012_v.nextInt(4);
        int dz = world.field_73012_v.nextInt(16) - world.field_73012_v.nextInt(16);
        EntityTFKobold hinty = new EntityTFKobold(world);
        hinty.func_174828_a(pos.func_177982_a(dx, dy, dz), 0.0f, 0.0f);
        if (hinty.func_70058_J() && hinty.func_70635_at().func_75522_a((Entity)player)) {
            ItemStack book = this.createHintBook();
            hinty.func_184201_a(EntityEquipmentSlot.MAINHAND, book);
            hinty.func_184642_a(EntityEquipmentSlot.MAINHAND, 1.0f);
            world.func_72838_d((Entity)hinty);
            return true;
        }
        return false;
    }

    public ItemStack createHintBook() {
        ItemStack book = new ItemStack(Items.field_151164_bB);
        this.addBookInformation(book, new NBTTagList());
        return book;
    }

    protected void addBookInformation(ItemStack book, NBTTagList bookPages) {
        TFFeature.addTranslatedPages(bookPages, "twilightforest.book.unknown", 2);
        book.func_77983_a("pages", (NBTBase)bookPages);
        book.func_77983_a("author", (NBTBase)new NBTTagString(BOOK_AUTHOR));
        book.func_77983_a("title", (NBTBase)new NBTTagString("Notes on the Unexplained"));
    }

    public StructureStartTFAbstract provideStructureStart(World world, Random rand, int chunkX, int chunkZ) {
        return new StructureStartNothing(world, rand, chunkX, chunkZ);
    }

    private static void addTranslatedPages(NBTTagList bookPages, String translationKey, int pageCount) {
        for (int i = 1; i <= pageCount; ++i) {
            bookPages.func_74742_a((NBTBase)new NBTTagString(ITextComponent.Serializer.func_150696_a((ITextComponent)new TextComponentTranslation(translationKey + "." + i, new Object[0]))));
        }
    }

    static {
        VALUES = TFFeature.values();
        maxSize = Arrays.stream(VALUES).mapToInt(v -> v.size).max().orElse(0);
    }
}

