/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.common.networking;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import net.gliby.voicechat.VoiceChat;
import net.gliby.voicechat.common.VoiceChatServer;
import net.gliby.voicechat.common.networking.ServerStreamManager;
import net.gliby.voicechat.common.networking.packets.MinecraftClientEntityDataPacket;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class ServerNetwork {
    private final VoiceChatServer voiceChat;
    private String externalAddress;
    public final ServerStreamManager dataManager;

    public ServerNetwork(VoiceChatServer voiceChat) {
        this.voiceChat = voiceChat;
        this.dataManager = new ServerStreamManager(voiceChat);
    }

    public String getAddress() {
        return this.externalAddress;
    }

    public ServerStreamManager getDataManager() {
        return this.dataManager;
    }

    public String[] getPlayerIPs() {
        List players = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        String[] ips = new String[players.size()];
        for (int i = 0; i < players.size(); ++i) {
            EntityPlayerMP p = (EntityPlayerMP)players.get(i);
            ips[i] = p.func_71114_r();
        }
        return ips;
    }

    public EntityPlayerMP[] getPlayers() {
        List pl = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        EntityPlayerMP[] players = pl.toArray(new EntityPlayerMP[pl.size()]);
        return players;
    }

    public void init() {
        if (this.voiceChat.getServerSettings().isUsingProxy()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ServerNetwork.this.externalAddress = ServerNetwork.this.retrieveExternalAddress();
                }
            }, "Extrernal Address Retriver Process").start();
        }
        this.dataManager.init();
    }

    private String retrieveExternalAddress() {
        VoiceChat.getLogger().info("Retrieving server address.");
        BufferedReader in = null;
        try {
            URL whatismyip = new URL("http://checkip.amazonaws.com");
            in = new BufferedReader(new InputStreamReader(whatismyip.openStream()));
            return in.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "0.0.0.0";
        }
    }

    public void sendEntityData(EntityPlayerMP player, int entityID, String username, double x, double y, double z) {
        VoiceChat.getDispatcher().sendTo((IMessage)new MinecraftClientEntityDataPacket(entityID, username, x, y, z), player);
    }

    public void stop() {
        this.dataManager.reset();
    }
}

