/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.common.networking.voiceservers;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import net.gliby.voicechat.VoiceChat;
import net.gliby.voicechat.common.VoiceChatServer;
import net.gliby.voicechat.common.networking.packets.MinecraftClientVoiceAuthenticatedServer;
import net.gliby.voicechat.common.networking.packets.MinecraftClientVoiceServerPacket;
import net.gliby.voicechat.common.networking.voiceservers.VoiceAuthenticatedServer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import org.apache.commons.lang3.RandomStringUtils;

public class ServerConnectionHandler {
    VoiceChatServer voiceChat;
    private List<GameProfile> loggedIn;

    public ServerConnectionHandler(VoiceChatServer vc) {
        this.voiceChat = vc;
        this.loggedIn = new ArrayList<GameProfile>();
    }

    @SubscribeEvent
    public void onJoin(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == Side.SERVER && !this.loggedIn.contains(event.player.func_146103_bH())) {
            this.loggedIn.add(event.player.func_146103_bH());
            this.onConnected(event.player);
        }
    }

    private void onConnected(EntityPlayer entity) {
        EntityPlayerMP player = (EntityPlayerMP)entity;
        if (this.voiceChat.getVoiceServer() instanceof VoiceAuthenticatedServer) {
            VoiceAuthenticatedServer voiceServer = (VoiceAuthenticatedServer)this.voiceChat.getVoiceServer();
            String hash = null;
            while (hash == null) {
                try {
                    hash = this.sha256(RandomStringUtils.random((int)32));
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
            }
            voiceServer.waitingAuth.put(hash, player);
            VoiceChat.getDispatcher().sendTo((IMessage)new MinecraftClientVoiceAuthenticatedServer(this.voiceChat.getServerSettings().canShowVoicePlates(), this.voiceChat.getServerSettings().canShowVoiceIcons(), this.voiceChat.getServerSettings().getMinimumSoundQuality(), this.voiceChat.getServerSettings().getMaximumSoundQuality(), this.voiceChat.getServerSettings().getBufferSize(), this.voiceChat.getServerSettings().getSoundDistance(), this.voiceChat.getVoiceServer().getType().ordinal(), this.voiceChat.getServerSettings().getUDPPort(), hash, this.voiceChat.serverSettings.isUsingProxy() ? this.voiceChat.serverNetwork.getAddress() : ""), player);
        } else {
            VoiceChat.getDispatcher().sendTo((IMessage)new MinecraftClientVoiceServerPacket(this.voiceChat.getServerSettings().canShowVoicePlates(), this.voiceChat.getServerSettings().canShowVoiceIcons(), this.voiceChat.getServerSettings().getMinimumSoundQuality(), this.voiceChat.getServerSettings().getMaximumSoundQuality(), this.voiceChat.getServerSettings().getBufferSize(), this.voiceChat.getServerSettings().getSoundDistance(), this.voiceChat.getVoiceServer().getType().ordinal()), player);
        }
        this.voiceChat.serverNetwork.dataManager.entityHandler.connected(player);
    }

    @SubscribeEvent
    public void onDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.loggedIn.remove(event.player.func_146103_bH());
            this.voiceChat.serverNetwork.dataManager.entityHandler.disconnected(event.player.func_145782_y());
        }
    }

    private String sha256(String s) throws NoSuchAlgorithmException {
        byte[] hash = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            hash = md.digest(s.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(hash[i]);
            if (hex.length() == 1) {
                sb.append(0);
                sb.append(hex.charAt(hex.length() - 1));
                continue;
            }
            sb.append(hex.substring(hex.length() - 2));
        }
        return sb.toString();
    }
}

