/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.forgehandler;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import java.util.EnumSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.forgehandler.EventHandlerManager;
import net.techbrew.journeymap.model.MapOverlayState;
import net.techbrew.journeymap.model.Waypoint;
import net.techbrew.journeymap.ui.UIManager;
import net.techbrew.journeymap.ui.map.MapOverlay;
import org.lwjgl.input.Keyboard;

public class KeyEventHandler
implements EventHandlerManager.EventHandler {
    public KeyEventHandler() {
        for (KeyBinding kb : Constants.initKeybindings()) {
            ClientRegistry.registerKeyBinding((KeyBinding)kb);
        }
    }

    @Override
    public EnumSet<EventHandlerManager.BusType> getBus() {
        return EnumSet.of(EventHandlerManager.BusType.FMLCommonHandlerBus);
    }

    @SubscribeEvent
    public void onKeyboardEvent(InputEvent.KeyInputEvent event) {
        KeyEventHandler.onKeypress(false);
    }

    public static void onKeypress(boolean minimapOnly) {
        int i = Keyboard.getEventKey();
        MapOverlayState mapOverlayState = MapOverlay.state();
        if (GuiScreen.func_146271_m() && JourneyMap.getInstance().miniMapProperties.enableHotkeys.get()) {
            if (Constants.isPressed(Constants.KB_MAP)) {
                UIManager.getInstance().toggleMinimap();
                return;
            }
            if (Constants.isPressed(Constants.KB_MAP_ZOOMIN)) {
                mapOverlayState.zoomIn();
                return;
            }
            if (Constants.isPressed(Constants.KB_MAP_ZOOMOUT)) {
                mapOverlayState.zoomOut();
                return;
            }
            if (Constants.isPressed(Constants.KB_MAP_DAY)) {
                mapOverlayState.overrideMapType(Constants.MapType.day);
                return;
            }
            if (Constants.isPressed(Constants.KB_MAP_NIGHT)) {
                mapOverlayState.overrideMapType(Constants.MapType.night);
                return;
            }
            if (Constants.isPressed(Constants.KB_MINIMAP_POS)) {
                UIManager.getInstance().getMiniMap().nextPosition();
                return;
            }
            if (Constants.isPressed(Constants.KB_WAYPOINT)) {
                UIManager.getInstance().openWaypointManager(null, null);
                return;
            }
        } else if (!minimapOnly) {
            if (Constants.KB_MAP.func_151468_f()) {
                if (Minecraft.func_71410_x().field_71462_r == null) {
                    UIManager.getInstance().openMap();
                } else if (Minecraft.func_71410_x().field_71462_r instanceof MapOverlay) {
                    UIManager.getInstance().closeAll();
                }
                return;
            }
            if (Constants.KB_WAYPOINT.func_151468_f()) {
                if (Minecraft.func_71410_x().field_71462_r == null) {
                    Minecraft mc = FMLClientHandler.instance().getClient();
                    Waypoint waypoint = Waypoint.of((EntityPlayer)mc.field_71439_g);
                    UIManager.getInstance().openWaypointEditor(waypoint, true, null);
                }
                return;
            }
        }
    }
}

