/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import java.util.Iterator;
import java.util.LinkedHashMap;
import net.minecraft.block.Block;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.model.BlockUtils;
import net.techbrew.journeymap.model.ChunkStub;

public class ChunkMD {
    public volatile float[][] surfaceSlopes;
    public volatile float[][] sliceSlopes;
    public final World worldObj;
    public final int worldHeight;
    public final Boolean hasNoSky;
    public final ChunkStub stub;
    public final ChunkCoordIntPair coord;
    public Boolean render;
    private int discards;

    public ChunkMD(Chunk chunk, Boolean render, World worldObj) {
        this(chunk, render, worldObj, false);
    }

    public ChunkMD(Chunk chunk, Boolean render, World worldObj, boolean doErrorChecks) {
        this(new ChunkStub(chunk), render, worldObj);
        if (chunk.func_76621_g() || !chunk.field_76636_d) {
            render = false;
        }
    }

    public ChunkMD(ChunkStub stub, Boolean render, World worldObj) {
        this.stub = stub;
        this.render = render;
        this.worldObj = worldObj;
        this.worldHeight = worldObj.func_72940_L();
        this.hasNoSky = worldObj.field_73011_w.field_76576_e;
        this.coord = new ChunkCoordIntPair(stub.field_76635_g, stub.field_76647_h);
    }

    public int discard(int i) {
        this.discards = Math.max(0, this.discards + i);
        return this.discards;
    }

    public Block getBlock(int x, int y, int z) {
        return this.stub.func_150810_a(x, y, z);
    }

    public int getSavedLightValue(EnumSkyBlock par1EnumSkyBlock, int x, int y, int z) {
        return this.stub.func_76614_a(par1EnumSkyBlock, x, Math.min(y, this.worldHeight - 1), z);
    }

    public int getSlopeHeightValue(int x, int z) {
        try {
            int y = this.getHeightValue(x, z);
            if (y < 1) {
                return 0;
            }
            Block block = this.getBlock(x, y, z);
            while (y > 0 && BlockUtils.hasFlag(block, BlockUtils.Flag.NoShadow)) {
                block = this.getBlock(x, --y, z);
            }
            return y;
        }
        catch (Exception e) {
            JourneyMap.getLogger().warning("Couldn't get safe height at " + x + "," + z + ": " + e);
            return this.getHeightValue(x, z);
        }
    }

    public int getHeightValue(int x, int z) {
        return this.stub.func_76611_b(x, z);
    }

    public int getAbsoluteHeightValue(int x, int z) {
        return this.stub.func_76626_d(x, z);
    }

    public int hashCode() {
        return this.coord.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChunkMD other = (ChunkMD)obj;
        if (this.stub.field_76635_g != other.stub.field_76635_g) {
            return false;
        }
        return this.stub.field_76647_h == other.stub.field_76647_h;
    }

    public String toString() {
        return "ChunkStubMD [" + this.stub.field_76635_g + ", " + this.stub.field_76647_h + "]";
    }

    public static class Set
    extends LinkedHashMap<ChunkCoordIntPair, ChunkMD>
    implements Iterable<ChunkMD> {
        public Set(int i) {
            super(i);
        }

        public void put(ChunkMD chunkMd) {
            super.put(chunkMd.coord, chunkMd);
        }

        public void add(ChunkMD chunkMd) {
            super.put(chunkMd.coord, chunkMd);
        }

        public ChunkMD remove(ChunkMD chunkMd) {
            return (ChunkMD)super.remove(chunkMd.coord);
        }

        public ChunkMD remove(ChunkCoordIntPair coord) {
            return (ChunkMD)super.remove(coord);
        }

        @Override
        public Iterator<ChunkMD> iterator() {
            return this.values().iterator();
        }
    }
}

