/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Since;
import cpw.mods.fml.client.FMLClientHandler;
import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import java.util.TreeSet;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.render.texture.TextureImpl;

public class Waypoint
implements Serializable {
    public static final int VERSION = 1;
    public static final Gson GSON = new GsonBuilder().setVersion(1.0).create();
    protected static final String ICON_NORMAL = "waypoint-normal.png";
    protected static final String ICON_DEATH = "waypoint-death.png";
    @Since(value=1.0)
    protected String id;
    @Since(value=1.0)
    protected String name;
    @Since(value=1.0)
    protected String icon;
    @Since(value=1.0)
    protected int x;
    @Since(value=1.0)
    protected int y;
    @Since(value=1.0)
    protected int z;
    @Since(value=1.0)
    protected int r;
    @Since(value=1.0)
    protected int g;
    @Since(value=1.0)
    protected int b;
    @Since(value=1.0)
    protected boolean enable;
    @Since(value=1.0)
    protected Type type;
    @Since(value=1.0)
    protected Origin origin;
    @Since(value=1.0)
    protected TreeSet<Integer> dimensions;
    protected transient boolean readOnly;
    protected transient boolean dirty;
    protected transient Minecraft mc = FMLClientHandler.instance().getClient();

    private Waypoint() {
    }

    public Waypoint(Waypoint original) {
        this(original.name, original.x, original.y, original.z, original.enable, original.r, original.g, original.b, original.type, original.origin, original.dimensions.first(), original.dimensions);
        this.x = original.x;
        this.y = original.y;
        this.z = original.z;
    }

    public Waypoint(String name, ChunkCoordinates location, Color color, Type type, Integer currentDimension) {
        this(name, location.field_71574_a, location.field_71572_b, location.field_71573_c, true, color.getRed(), color.getGreen(), color.getBlue(), type, Origin.JourneyMap, currentDimension, Arrays.asList(currentDimension));
    }

    public Waypoint(String name, int x, int y, int z, boolean enable, int red, int green, int blue, Type type, Origin origin, Integer currentDimension, Collection<Integer> dimensions) {
        if (name == null) {
            name = Waypoint.createName(x, z);
        }
        if (dimensions == null || dimensions.size() == 0) {
            dimensions = new TreeSet<Integer>();
            dimensions.add(this.mc.field_71439_g.field_70170_p.field_73011_w.field_76574_g);
        }
        this.dimensions = new TreeSet<Integer>(dimensions);
        this.dimensions.add(currentDimension);
        this.name = name;
        this.setLocation(x, y, z, currentDimension);
        this.r = red;
        this.g = green;
        this.b = blue;
        this.enable = enable;
        this.type = type;
        this.origin = origin;
        switch (type) {
            case Normal: {
                this.icon = ICON_NORMAL;
                break;
            }
            case Death: {
                this.icon = ICON_DEATH;
            }
        }
    }

    public static Waypoint deathOf(Entity player) {
        ChunkCoordinates cc = new ChunkCoordinates((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        return Waypoint.at(cc, Type.Death, player.field_70170_p.field_73011_w.field_76574_g);
    }

    public static Waypoint of(EntityPlayer player) {
        ChunkCoordinates cc = new ChunkCoordinates((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        return Waypoint.at(cc, Type.Normal, player.field_70170_p.field_73011_w.field_76574_g);
    }

    public static Waypoint at(ChunkCoordinates cc, Type type, int dimension) {
        String name = type == Type.Death ? Constants.getString("Waypoint.deathpoint") : Waypoint.createName(cc.field_71574_a, cc.field_71573_c);
        Waypoint waypoint = new Waypoint(name, cc, Color.white, type, dimension);
        waypoint.setRandomColor();
        return waypoint;
    }

    private static String createName(int x, int z) {
        return String.format("%s, %s", x, z);
    }

    public void setLocation(int x, int y, int z, int currentDimension) {
        this.x = currentDimension == -1 ? x * 8 : x;
        this.y = y;
        this.z = currentDimension == -1 ? z * 8 : z;
        this.updateId();
    }

    public String updateId() {
        String oldId = this.id;
        this.id = String.format("%s_%s,%s,%s", this.name, this.x, this.y, this.z);
        return oldId;
    }

    public boolean isDeathPoint() {
        return this.type == Type.Death;
    }

    public TextureImpl getTexture() {
        return this.isDeathPoint() ? TextureCache.instance().getDeathpoint() : TextureCache.instance().getWaypoint();
    }

    public ChunkCoordIntPair getChunkCoordIntPair() {
        return new ChunkCoordIntPair(this.x >> 4, this.z >> 4);
    }

    public void setRandomColor() {
        Random random = new Random();
        int r = random.nextInt(255);
        int g = random.nextInt(255);
        int b = random.nextInt(255);
        int min = 100;
        int max = Math.max(r, Math.max(g, b));
        if (max < min) {
            if (r == max) {
                r = min;
            } else if (g == max) {
                g = min;
            } else {
                b = min;
            }
        }
        this.setColor(new Color(r, g, b));
    }

    public Color getColor() {
        return new Color(this.r, this.g, this.b);
    }

    public void setColor(Color color) {
        this.r = color.getRed();
        this.g = color.getGreen();
        this.b = color.getBlue();
    }

    public Color getSafeColor() {
        if (this.r + this.g + this.b >= 100) {
            return this.getColor();
        }
        return Color.darkGray;
    }

    public Collection<Integer> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Collection<Integer> dims) {
        this.dimensions = new TreeSet<Integer>(dims);
    }

    public boolean isTeleportReady() {
        return this.y >= 0 && this.isInPlayerDimension();
    }

    public boolean isInPlayerDimension() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        return this.dimensions.contains(mc.field_71439_g.field_70170_p.field_73011_w.field_76574_g);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public int getX() {
        return this.mc.field_71439_g.field_71093_bK == -1 ? this.x / 8 : this.x;
    }

    public double getBlockCenteredX() {
        int x = this.getX();
        return (double)x + (x < 0 ? -0.5 : 0.5);
    }

    public int getY() {
        return this.y;
    }

    public double getBlockCenteredY() {
        return (double)this.getY() + 0.5;
    }

    public int getZ() {
        return this.mc.field_71439_g.field_71093_bK == -1 ? this.z / 8 : this.z;
    }

    public double getBlockCenteredZ() {
        int z = this.getZ();
        return (double)z + (z < 0 ? -0.5 : 0.5);
    }

    public Vec3 getPosition() {
        return Vec3.func_72443_a((double)this.getBlockCenteredX(), (double)this.getBlockCenteredY(), (double)this.getBlockCenteredZ());
    }

    public int getR() {
        return this.r;
    }

    public void setR(int r) {
        this.r = r;
    }

    public int getG() {
        return this.g;
    }

    public void setG(int g) {
        this.g = g;
    }

    public int getB() {
        return this.b;
    }

    public void setB(int b) {
        this.b = b;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        if (enable != this.enable) {
            this.enable = enable;
            this.dirty = true;
        }
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public void setOrigin(Origin origin) {
        this.origin = origin;
    }

    public String getFileName() {
        return this.id.replaceAll("[\\\\/:\"*?<>|]", "_").concat(".json");
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String toString() {
        return GSON.toJson((Object)this);
    }

    public static Waypoint fromString(String json) {
        return (Waypoint)GSON.fromJson(json, Waypoint.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Waypoint waypoint = (Waypoint)o;
        if (this.b != waypoint.b) {
            return false;
        }
        if (this.enable != waypoint.enable) {
            return false;
        }
        if (this.g != waypoint.g) {
            return false;
        }
        if (this.r != waypoint.r) {
            return false;
        }
        if (this.x != waypoint.x) {
            return false;
        }
        if (this.y != waypoint.y) {
            return false;
        }
        if (this.z != waypoint.z) {
            return false;
        }
        if (!this.dimensions.equals(waypoint.dimensions)) {
            return false;
        }
        if (!this.icon.equals(waypoint.icon)) {
            return false;
        }
        if (!this.id.equals(waypoint.id)) {
            return false;
        }
        if (!this.name.equals(waypoint.name)) {
            return false;
        }
        if (this.origin != waypoint.origin) {
            return false;
        }
        return this.type == waypoint.type;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static enum Type {
        Normal,
        Death;

    }

    public static enum Origin {
        JourneyMap,
        ReiMinimap,
        VoxelMap;

    }
}

