/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.properties;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.concurrent.atomic.AtomicBoolean;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.log.LogFormatter;

public abstract class PropertiesBase {
    protected final transient Gson gson = new GsonBuilder().setPrettyPrinting().create();
    protected final transient AtomicBoolean saveEnabled = new AtomicBoolean(true);
    private static final String[] HEADERS = new String[]{"// JourneyMap configuration file. Modify at your own risk!", "// To restore the default settings, simply delete this file before starting Minecraft", "// For help with this file, see http://journeymap.techbrew.net/help/wiki/Configuration_Files"};

    public abstract String getName();

    public abstract int getCurrentRevision();

    public abstract int getRevision();

    public File getFile() {
        return new File(FileHandler.getConfigDir(), String.format("journeymap.%s.config", this.getName()));
    }

    public boolean isCurrent() {
        return this.getCurrentRevision() == this.getRevision();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        AtomicBoolean atomicBoolean = this.saveEnabled;
        synchronized (atomicBoolean) {
            if (!this.saveEnabled.get()) {
                return false;
            }
            File propFile = null;
            try {
                propFile = this.getFile();
                if (!propFile.exists()) {
                    JourneyMap.getLogger().info(String.format("Creating config file: %s", propFile));
                    if (!propFile.getParentFile().exists()) {
                        propFile.getParentFile().mkdirs();
                    }
                }
                String lineEnding = System.getProperty("line.separator");
                StringBuilder sb = new StringBuilder();
                for (String line : HEADERS) {
                    sb.append(line).append(lineEnding);
                }
                String header = sb.toString();
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                String json = gson.toJson((Object)this);
                FileWriter fw = new FileWriter(propFile);
                fw.write(header);
                fw.write(json);
                fw.flush();
                fw.close();
                return true;
            }
            catch (Exception e) {
                JourneyMap.getLogger().severe(String.format("Can't save config file %s: %s", propFile, LogFormatter.toString(e)));
                return false;
            }
        }
    }

    public boolean toggle(AtomicBoolean ab) {
        ab.set(!ab.get());
        this.save();
        return ab.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public <T extends PropertiesBase> T load() {
        instance = this;
        propFile = this.getFile();
        reader = null;
        saveNeeded = true;
        try {
            if (propFile.canRead()) {
                reader = new FileReader(propFile);
                instance = (PropertiesBase)this.gson.fromJson((Reader)reader, this.getClass());
                v0 = saveNeeded = instance.isCurrent() == false;
                if (saveNeeded) {
                    JourneyMap.getLogger().info(String.format("Config file needs to be updated: %s", new Object[]{propFile.getName()}));
                }
            } else {
                JourneyMap.getLogger().info(String.format("Config file not found: %s", new Object[]{propFile}));
            }
            ** if (reader == null) goto lbl-1000
        }
        catch (Exception e) {
            try {
                JourneyMap.getLogger().severe(String.format("Can't load config file %s: %s", new Object[]{propFile, e.getMessage()}));
                ** if (reader == null) goto lbl-1000
            }
            catch (Throwable var6_8) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        JourneyMap.getLogger().severe(String.format("Can't close config file %s: %s", new Object[]{propFile, e.getMessage()}));
                    }
                }
                throw var6_8;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    JourneyMap.getLogger().severe(String.format("Can't close config file %s: %s", new Object[]{propFile, e.getMessage()}));
                }
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                reader.close();
            }
            catch (Exception e) {
                JourneyMap.getLogger().severe(String.format("Can't close config file %s: %s", new Object[]{propFile, e.getMessage()}));
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        if (saveNeeded) {
            instance.save();
        }
        return (T)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends PropertiesBase> T enableSave(boolean enabled) {
        AtomicBoolean atomicBoolean = this.saveEnabled;
        synchronized (atomicBoolean) {
            this.saveEnabled.set(enabled);
            return (T)this;
        }
    }
}

