/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.draw;

import java.awt.Color;
import java.awt.geom.Point2D;
import net.techbrew.journeymap.render.draw.DrawStep;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.overlay.GridRenderer;

public class DrawCenteredLabelStep
implements DrawStep {
    final double posX;
    final double posZ;
    final String text;
    final int labelYOffset;
    final Color bgColor;
    final Color fgColor;

    public DrawCenteredLabelStep(double posX, double posZ, String text, int labelYOffset, Color bgColor, Color fgColor) {
        this.posX = posX;
        this.posZ = posZ;
        this.text = text;
        this.labelYOffset = labelYOffset;
        this.bgColor = bgColor;
        this.fgColor = fgColor;
    }

    @Override
    public void draw(double xOffset, double yOffset, GridRenderer gridRenderer, float drawScale, double fontScale) {
        Point2D.Double pixel = gridRenderer.getPixel(this.posX, this.posZ);
        if (pixel != null) {
            DrawUtil.drawCenteredLabel(this.text, ((Point2D)pixel).getX() + xOffset, ((Point2D)pixel).getY() + yOffset + (double)this.labelYOffset, this.bgColor, 205, this.fgColor, 255, fontScale);
        }
    }
}

