/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.overlay;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.EntityDTO;
import net.techbrew.journeymap.properties.MapProperties;
import net.techbrew.journeymap.render.draw.DrawCenteredLabelStep;
import net.techbrew.journeymap.render.draw.DrawEntityStep;
import net.techbrew.journeymap.render.draw.DrawPlayerStep;
import net.techbrew.journeymap.render.draw.DrawStep;
import net.techbrew.journeymap.render.overlay.GridRenderer;
import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.render.texture.TextureImpl;

public class OverlayRadarRenderer {
    public List<DrawStep> prepareSteps(List<EntityDTO> entityDTOs, GridRenderer grid, float drawScale, MapProperties mapProperties) {
        boolean showAnimals = mapProperties.showAnimals.get();
        boolean showPets = mapProperties.showPets.get();
        int fontHeight = 14;
        Color labelBg = Color.darkGray.darker();
        ArrayList<DrawStep> drawStepList = new ArrayList<DrawStep>();
        try {
            boolean filterAnimals = showAnimals != showPets;
            String playername = Minecraft.func_71410_x().field_71439_g.getDisplayName();
            TextureCache tc = TextureCache.instance();
            for (EntityDTO dto : entityDTOs) {
                TextureImpl entityIcon;
                double posZ;
                double posX;
                Boolean isHostile = Boolean.TRUE.equals(dto.hostile);
                String owner = dto.owner;
                Boolean isPet = playername.equals(owner);
                if (filterAnimals && !isHostile.booleanValue() && showPets != isPet || grid.getPixel(posX = Double.valueOf(dto.posX).doubleValue(), posZ = Double.valueOf(dto.posZ).doubleValue()) == null) continue;
                String filename = dto.filename;
                Boolean isPlayer = filename.startsWith("/skin/");
                TextureImpl locatorImg = isHostile != false ? tc.getHostileLocator() : (isPet != false ? tc.getPetLocator() : (isPlayer != false ? tc.getOtherLocator() : tc.getNeutralLocator()));
                EntityLivingBase entity = dto.entityLiving;
                drawStepList.add(new DrawEntityStep((Entity)entity, false, locatorImg, (int)(8.0f * drawScale)));
                if (isPlayer.booleanValue()) {
                    entityIcon = tc.getPlayerSkin(dto.username);
                    drawStepList.add(new DrawPlayerStep((EntityPlayer)entity, entityIcon));
                    continue;
                }
                entityIcon = tc.getEntityImage(filename);
                if (entityIcon != null) {
                    int bottomMargin = isPlayer != false ? 0 : (int)(8.0f * drawScale);
                    drawStepList.add(new DrawEntityStep((Entity)entity, true, entityIcon, bottomMargin));
                }
                if (dto.customName == null) continue;
                drawStepList.add(new DrawCenteredLabelStep(posX, posZ, dto.customName, entityIcon.height / 2, labelBg, Color.white));
            }
        }
        catch (Throwable t) {
            JourneyMap.getLogger().severe("Error during prepareSteps: " + LogFormatter.toString(t));
        }
        return drawStepList;
    }
}

