/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.map;

import cpw.mods.fml.client.FMLClientHandler;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.VersionCheck;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.data.WaypointsData;
import net.techbrew.journeymap.feature.Feature;
import net.techbrew.journeymap.feature.FeatureManager;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.log.StatTimer;
import net.techbrew.journeymap.model.BlockCoordIntPair;
import net.techbrew.journeymap.model.MapOverlayState;
import net.techbrew.journeymap.model.Waypoint;
import net.techbrew.journeymap.properties.FullMapProperties;
import net.techbrew.journeymap.properties.PropertiesBase;
import net.techbrew.journeymap.render.draw.DrawEntityStep;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.overlay.GridRenderer;
import net.techbrew.journeymap.render.overlay.OverlayRadarRenderer;
import net.techbrew.journeymap.render.overlay.OverlayWaypointRenderer;
import net.techbrew.journeymap.render.overlay.TileCache;
import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.render.texture.TextureImpl;
import net.techbrew.journeymap.ui.BooleanPropertyButton;
import net.techbrew.journeymap.ui.Button;
import net.techbrew.journeymap.ui.ButtonList;
import net.techbrew.journeymap.ui.JmUI;
import net.techbrew.journeymap.ui.UIManager;
import net.techbrew.journeymap.ui.map.MapChat;
import net.techbrew.journeymap.ui.map.layer.LayerDelegate;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class MapOverlay
extends JmUI {
    static final MapOverlayState state = new MapOverlayState();
    final OverlayWaypointRenderer waypointRenderer = new OverlayWaypointRenderer();
    final OverlayRadarRenderer radarRenderer = new OverlayRadarRenderer();
    static final GridRenderer gridRenderer = new GridRenderer(5);
    final LayerDelegate layerDelegate = new LayerDelegate();
    final FullMapProperties fullMapProperties;
    Boolean isScrolling;
    int msx;
    int msy;
    int mx;
    int my;
    Logger logger;
    MapChat chat;
    Button buttonDayNight;
    Button buttonFollow;
    Button buttonZoomIn;
    Button buttonZoomOut;
    Button buttonAlert;
    Button buttonOptions;
    Button buttonActions;
    Button buttonClose;
    Button buttonMode;
    Button buttonWaypointManager;
    Button buttonCaves;
    ButtonList leftButtons;
    ButtonList rightButtons;
    Color bgColor;
    Color playerInfoFgColor;
    Color playerInfoBgColor;
    StatTimer drawScreenTimer;
    StatTimer drawMapTimer;
    StatTimer drawMapTimerWithRefresh;

    public MapOverlay() {
        super(null);
        this.fullMapProperties = JourneyMap.getInstance().fullMapProperties;
        this.isScrolling = false;
        this.logger = JourneyMap.getLogger();
        this.bgColor = new Color(34, 34, 34);
        this.playerInfoFgColor = Color.lightGray;
        this.playerInfoBgColor = new Color(34, 34, 34);
        this.drawScreenTimer = StatTimer.get("MapOverlay.drawScreen");
        this.drawMapTimer = StatTimer.get("MapOverlay.drawScreen.drawMap");
        this.drawMapTimerWithRefresh = StatTimer.get("MapOverlay.drawScreen.drawMap+refreshState");
        this.field_146297_k = FMLClientHandler.instance().getClient();
        state.refresh(this.field_146297_k, this.field_146297_k.field_71439_g, this.fullMapProperties);
        gridRenderer.setContext(state.getWorldDir(), state.getDimension());
        gridRenderer.setZoom(MapOverlay.state.currentZoom);
    }

    @Override
    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.initButtons();
        if (state.getDimension() != this.field_146297_k.field_71439_g.field_71093_bK) {
            gridRenderer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void func_73863_a(int width, int height, float f) {
        try {
            this.drawScreenTimer.start();
            this.func_146278_c(0);
            this.drawMap();
            this.layoutButtons();
            for (int k = 0; k < this.field_146292_n.size(); ++k) {
                GuiButton guibutton = (GuiButton)this.field_146292_n.get(k);
                guibutton.func_146112_a(this.field_146297_k, width, height);
            }
            if (this.chat != null) {
                this.chat.func_73863_a(width, height, f);
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "Unexpected exception in MapOverlay.drawScreen(): " + LogFormatter.toString(e));
            UIManager.getInstance().closeAll();
        }
        finally {
            this.drawScreenTimer.stop();
        }
    }

    protected void func_146284_a(GuiButton guibutton) {
        ButtonEnum id = ButtonEnum.values()[guibutton.field_146127_k];
        switch (id) {
            case DayNight: {
                this.toggleDayNight();
                break;
            }
            case Follow: {
                this.toggleFollow();
                break;
            }
            case ZoomIn: {
                this.zoomIn();
                break;
            }
            case ZoomOut: {
                this.zoomOut();
                break;
            }
            case Close: {
                UIManager.getInstance().closeAll();
                break;
            }
            case Alert: {
                VersionCheck.launchWebsite();
                break;
            }
            case Options: {
                UIManager.getInstance().openMasterOptions();
                break;
            }
            case Actions: {
                UIManager.getInstance().openMapActions();
                break;
            }
            case WaypointManager: {
                UIManager.getInstance().openWaypointManager(null, ((Object)((Object)this)).getClass());
            }
            case Caves: {
                if (!this.buttonCaves.isEnabled()) break;
                this.buttonCaves.toggle();
                this.refreshState();
            }
        }
    }

    @Override
    public void func_146280_a(Minecraft minecraft, int width, int height) {
        super.func_146280_a(minecraft, width, height);
        state.requireRefresh();
        this.layoutButtons();
        if (this.chat == null) {
            this.chat = new MapChat("", true);
        }
        if (this.chat != null) {
            this.chat.func_146280_a(minecraft, width, height);
        }
        this.func_73866_w_();
        this.drawMap();
    }

    void initButtons() {
        if (this.field_146292_n.isEmpty()) {
            FontRenderer fr = this.getFontRenderer();
            String on = Constants.getString("MapOverlay.on");
            String off = Constants.getString("MapOverlay.off");
            this.buttonAlert = new Button(ButtonEnum.Alert, Constants.getString("MapOverlay.update_available"));
            this.buttonAlert.fitWidth(fr);
            this.buttonAlert.setDrawButton(VersionCheck.getVersionIsChecked() != false && VersionCheck.getVersionIsCurrent() == false);
            this.buttonDayNight = new Button((Enum)ButtonEnum.DayNight, Constants.getString("MapOverlay.day"), Constants.getString("MapOverlay.night"), state.getMapType(this.fullMapProperties.showCaves.get()) == Constants.MapType.day);
            this.buttonDayNight.fitWidth(fr);
            this.buttonDayNight.setNoDisableText(true);
            this.buttonFollow = new Button((Enum)ButtonEnum.Follow, Constants.getString("MapOverlay.follow", on), Constants.getString("MapOverlay.follow", off), MapOverlay.state.follow);
            this.buttonFollow.fitWidth(fr);
            this.buttonZoomIn = new Button(ButtonEnum.ZoomIn, "+");
            this.buttonZoomIn.setNoDisableText(true);
            this.buttonZoomIn.setWidth(20);
            this.buttonZoomIn.setEnabled(MapOverlay.state.currentZoom < MapOverlay.state.maxZoom);
            this.buttonZoomOut = new Button(ButtonEnum.ZoomOut, "-");
            this.buttonZoomOut.setNoDisableText(true);
            this.buttonZoomOut.setWidth(20);
            this.buttonZoomOut.setEnabled(MapOverlay.state.currentZoom > MapOverlay.state.minZoom);
            this.buttonClose = new Button(ButtonEnum.Close, Constants.getString("MapOverlay.close"));
            this.buttonClose.fitWidth(fr);
            this.buttonOptions = new Button(ButtonEnum.Options, Constants.getString("MapOverlay.options"));
            this.buttonOptions.fitWidth(fr);
            this.buttonActions = new Button(ButtonEnum.Actions, Constants.getString("MapOverlay.actions"));
            this.buttonActions.fitWidth(fr);
            this.buttonCaves = BooleanPropertyButton.create(ButtonEnum.Caves.ordinal(), "MapOverlay.caves", (PropertiesBase)this.fullMapProperties, this.fullMapProperties.showCaves);
            this.buttonCaves.fitWidth(fr);
            this.buttonCaves.setNoDisableText(true);
            this.buttonCaves.setDrawButton(FeatureManager.isAllowed(Feature.MapCaves));
            this.buttonWaypointManager = new Button(ButtonEnum.WaypointManager, Constants.getString("Waypoint.waypoints"));
            this.buttonWaypointManager.fitWidth(fr);
            this.buttonWaypointManager.setDrawButton(WaypointsData.isManagerEnabled());
            if (this.buttonAlert.isDrawButton()) {
                this.field_146292_n.add(this.buttonAlert);
            }
            this.field_146292_n.add(this.buttonDayNight);
            this.field_146292_n.add(this.buttonFollow);
            if (FeatureManager.isAllowed(Feature.MapCaves)) {
                // empty if block
            }
            this.field_146292_n.add(this.buttonCaves);
            this.field_146292_n.add(this.buttonZoomIn);
            this.field_146292_n.add(this.buttonZoomOut);
            this.field_146292_n.add(this.buttonClose);
            this.field_146292_n.add(this.buttonOptions);
            this.field_146292_n.add(this.buttonActions);
            this.field_146292_n.add(this.buttonWaypointManager);
            this.leftButtons = new ButtonList(this.buttonDayNight, this.buttonFollow, this.buttonCaves);
            this.rightButtons = new ButtonList(this.buttonAlert, this.buttonWaypointManager, this.buttonOptions, this.buttonActions, this.buttonClose);
            Collections.reverse(this.rightButtons);
        }
    }

    @Override
    protected void layoutButtons() {
        if (this.field_146292_n.isEmpty()) {
            this.initButtons();
        }
        int startX = 40;
        int endX = this.field_146294_l - 3;
        int startY = 3;
        int hgap = 3;
        int vgap = 3;
        this.buttonZoomIn.setPosition(8, 32);
        this.buttonZoomOut.below(this.buttonZoomIn, 8).setX(8);
        this.buttonCaves.setEnabled(!this.field_146297_k.field_71441_e.field_73011_w.field_76576_e && DataCache.getPlayer().underground != false && FeatureManager.isAllowed(Feature.MapCaves));
        boolean underground = DataCache.getPlayer().underground != false && FeatureManager.isAllowed(Feature.MapCaves) && JourneyMap.getInstance().fullMapProperties.showCaves.get();
        this.buttonDayNight.setEnabled(!underground);
        this.leftButtons.layoutHorizontal(40, 3, true, 3);
        this.buttonDayNight.setPosition(40, 3);
        this.buttonWaypointManager.setDrawButton(JourneyMap.getInstance().waypointProperties.managerEnabled.get());
        int rightX = this.leftButtons.getRightX() + 3;
        if (rightX <= this.field_146294_l - this.rightButtons.getWidth(3)) {
            if (!this.rightButtons.isHorizontal()) {
                this.rightButtons.setFitWidths(this.field_146297_k.field_71466_p);
            }
            this.rightButtons.layoutHorizontal(endX, 3, false, 3);
        } else {
            if (this.rightButtons.isHorizontal()) {
                this.rightButtons.setUniformWidths(this.field_146297_k.field_71466_p);
            }
            this.rightButtons.layoutVertical(endX, 3, false, 3);
        }
    }

    public void func_146274_d() {
        if (this.chat != null && !this.chat.isHidden()) {
            this.chat.func_146274_d();
        }
        this.mx = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        this.my = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        if (Mouse.getEventButtonState()) {
            this.func_73864_a(this.mx, this.my, Mouse.getEventButton());
        } else {
            int wheel = Mouse.getEventDWheel();
            if (wheel > 0) {
                this.zoomIn();
            } else if (wheel < 0) {
                this.zoomOut();
            } else {
                this.func_146286_b(this.mx, this.my, Mouse.getEventButton());
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (this.chat != null && !this.chat.isHidden()) {
            this.chat.func_73864_a(mouseX, mouseY, mouseButton);
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
        Boolean guiButtonUsed = false;
        if (mouseButton == 0) {
            for (int l = 0; l < this.field_146292_n.size(); ++l) {
                GuiButton guibutton = (GuiButton)this.field_146292_n.get(l);
                if (!guibutton.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
                guiButtonUsed = true;
                break;
            }
        }
        if (!guiButtonUsed.booleanValue()) {
            BlockCoordIntPair blockCoord = gridRenderer.getBlockUnderMouse(mouseX, mouseY, this.field_146294_l, this.field_146295_m);
            double gridMouseX = 1.0 * (double)mouseX * (double)gridRenderer.getWidth() / (double)this.field_146294_l;
            double gridMouseY = 1.0 * (double)mouseY * (double)gridRenderer.getHeight() / (double)this.field_146295_m;
            this.layerDelegate.onMouseClicked(this.field_146297_k, gridMouseX, gridMouseY, gridRenderer.getWidth(), gridRenderer.getHeight(), blockCoord, mouseButton);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int which) {
        super.func_146286_b(mouseX, mouseY, which);
        if (Mouse.isButtonDown((int)0) && this.mouseOverButtons(mouseX, mouseY)) {
            return;
        }
        int blockSize = (int)Math.pow(2.0, MapOverlay.state.currentZoom);
        if (Mouse.isButtonDown((int)0) && !this.isScrolling.booleanValue()) {
            this.isScrolling = true;
            this.msx = this.mx;
            this.msy = this.my;
        } else if (!Mouse.isButtonDown((int)0) && this.isScrolling.booleanValue()) {
            this.isScrolling = false;
            int mouseDragX = (this.mx - this.msx) * 2 / blockSize;
            int mouseDragY = (this.my - this.msy) * 2 / blockSize;
            this.msx = this.mx;
            this.msy = this.my;
            try {
                gridRenderer.move(-mouseDragX, -mouseDragY);
                gridRenderer.updateTextures(state.getMapType(this.fullMapProperties.showCaves.get()), state.getVSlice(), this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d, false, 0.0, 0.0, this.fullMapProperties);
                gridRenderer.setZoom(MapOverlay.state.currentZoom);
            }
            catch (Exception e) {
                this.logger.severe("Error moving grid: " + e);
            }
            this.setFollow(false);
            this.refreshState();
        }
        if (!this.isScrolling.booleanValue() && which == -1) {
            BlockCoordIntPair blockCoord = gridRenderer.getBlockUnderMouse(mouseX, mouseY, this.field_146294_l, this.field_146295_m);
            double gridMouseX = 1.0 * (double)mouseX * (double)gridRenderer.getWidth() / (double)this.field_146294_l;
            double gridMouseY = 1.0 * (double)mouseY * (double)gridRenderer.getHeight() / (double)this.field_146295_m;
            this.layerDelegate.onMouseMove(this.field_146297_k, gridMouseX, gridMouseY, gridRenderer.getWidth(), gridRenderer.getHeight(), blockCoord);
        }
    }

    void zoomIn() {
        if (MapOverlay.state.currentZoom < MapOverlay.state.maxZoom) {
            this.setZoom(MapOverlay.state.currentZoom + 1);
        }
    }

    void zoomOut() {
        if (MapOverlay.state.currentZoom > MapOverlay.state.minZoom) {
            this.setZoom(MapOverlay.state.currentZoom - 1);
        }
    }

    private void setZoom(int zoom) {
        if (state.setZoom(zoom)) {
            this.buttonZoomOut.setEnabled(MapOverlay.state.currentZoom > MapOverlay.state.minZoom);
            this.buttonZoomIn.setEnabled(MapOverlay.state.currentZoom < MapOverlay.state.maxZoom);
            this.refreshState();
        }
    }

    void toggleDayNight() {
        this.buttonDayNight.toggle();
        if (this.buttonDayNight.getToggled().booleanValue()) {
            state.overrideMapType(Constants.MapType.day);
        } else {
            state.overrideMapType(Constants.MapType.night);
        }
        this.refreshState();
    }

    void toggleFollow() {
        this.setFollow(!MapOverlay.state.follow);
    }

    void setFollow(Boolean onPlayer) {
        if (MapOverlay.state.follow == onPlayer) {
            return;
        }
        this.buttonFollow.setToggled(onPlayer);
        MapOverlay.state.follow = onPlayer;
        if (MapOverlay.state.follow) {
            this.refreshState();
        }
    }

    @Override
    public void func_73869_a(char c, int i) {
        if (this.chat != null && !this.chat.isHidden()) {
            this.chat.func_73869_a(c, i);
            return;
        }
        if (i == 1 || Constants.isPressed(Constants.KB_MAP)) {
            UIManager.getInstance().closeAll();
            return;
        }
        if (Constants.isPressed(Constants.KB_MAP_ZOOMIN)) {
            this.zoomIn();
            return;
        }
        if (Constants.isPressed(Constants.KB_MAP_ZOOMOUT)) {
            this.zoomOut();
            return;
        }
        if (Constants.isPressed(Constants.KB_MAP_DAY)) {
            state.overrideMapType(Constants.MapType.day);
            return;
        }
        if (Constants.isPressed(Constants.KB_MAP_NIGHT)) {
            state.overrideMapType(Constants.MapType.night);
            return;
        }
        if (Constants.isPressed(Constants.KB_WAYPOINT)) {
            Waypoint waypoint = Waypoint.of((EntityPlayer)this.field_146297_k.field_71439_g);
            UIManager.getInstance().openWaypointEditor(waypoint, true, null);
            return;
        }
        if (Constants.isPressed(this.field_146297_k.field_71474_y.field_74351_w)) {
            this.moveCanvas(0, -16);
            return;
        }
        if (Constants.isPressed(this.field_146297_k.field_71474_y.field_74370_x)) {
            this.moveCanvas(-16, 0);
            return;
        }
        if (Constants.isPressed(this.field_146297_k.field_71474_y.field_74368_y)) {
            this.moveCanvas(0, 16);
            return;
        }
        if (Constants.isPressed(this.field_146297_k.field_71474_y.field_74366_z)) {
            this.moveCanvas(16, 0);
            return;
        }
        if (Constants.isPressed(this.field_146297_k.field_71474_y.field_151445_Q)) {
            UIManager.getInstance().openInventory();
            return;
        }
        if (Constants.isPressed(this.field_146297_k.field_71474_y.field_74310_D)) {
            this.openChat("");
            return;
        }
        if (Constants.isPressed(this.field_146297_k.field_71474_y.field_74323_J)) {
            this.openChat("/");
            return;
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.chat != null) {
            this.chat.func_73876_c();
        }
        this.layoutButtons();
    }

    @Override
    public void func_146278_c(int layer) {
        DrawUtil.drawRectangle(0.0, 0.0, this.field_146294_l, this.field_146295_m, this.bgColor, 255);
    }

    void drawMap() {
        Point2D.Double playerPixel;
        float drawScale;
        boolean refreshReady = this.isRefreshReady();
        StatTimer timer = refreshReady ? this.drawMapTimerWithRefresh : this.drawMapTimer;
        timer.start();
        this.sizeDisplay(false);
        int xOffset = 0;
        int yOffset = 0;
        if (this.isScrolling.booleanValue()) {
            int blockSize = (int)Math.pow(2.0, MapOverlay.state.currentZoom);
            int mouseDragX = (this.mx - this.msx) * 2 / blockSize;
            int mouseDragY = (this.my - this.msy) * 2 / blockSize;
            xOffset = mouseDragX * blockSize;
            yOffset = mouseDragY * blockSize;
        } else if (refreshReady) {
            this.refreshState();
        } else {
            gridRenderer.setContext(state.getWorldDir(), state.getDimension());
        }
        boolean unicodeForced = DrawUtil.startUnicode(this.field_146297_k.field_71466_p, this.fullMapProperties.forceUnicode.get());
        float f = drawScale = this.fullMapProperties.textureSmall.get() ? 1.0f : 2.0f;
        if (MapOverlay.state.follow) {
            gridRenderer.center(this.field_146297_k.field_71439_g.field_70165_t, this.field_146297_k.field_71439_g.field_70161_v, MapOverlay.state.currentZoom);
        }
        gridRenderer.updateTextures(state.getMapType(this.fullMapProperties.showCaves.get()), state.getVSlice(), this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d, false, 0.0, 0.0, this.fullMapProperties);
        gridRenderer.draw(1.0f, xOffset, yOffset);
        gridRenderer.draw(state.getDrawSteps(), (double)xOffset, (double)yOffset, drawScale, this.getMapFontScale());
        if (this.fullMapProperties.showSelf.get() && (playerPixel = gridRenderer.getPixel(this.field_146297_k.field_71439_g.field_70165_t, this.field_146297_k.field_71439_g.field_70161_v)) != null) {
            TextureImpl tex = MapOverlay.state.currentZoom == 0 ? TextureCache.instance().getPlayerLocatorSmall() : TextureCache.instance().getPlayerLocator();
            DrawEntityStep drawStep = new DrawEntityStep((Entity)this.field_146297_k.field_71439_g, false, tex, 8);
            gridRenderer.draw(xOffset, (double)yOffset, 1.0f, (double)this.getMapFontScale(), drawStep);
        }
        gridRenderer.draw(this.layerDelegate.getDrawSteps(), (double)xOffset, (double)yOffset, drawScale, this.getMapFontScale());
        DrawUtil.drawLabel(MapOverlay.state.playerLastPos, this.field_146297_k.field_71443_c / 2, this.field_146297_k.field_71440_d, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, this.playerInfoBgColor, 235, this.playerInfoFgColor, 255, this.getMapFontScale(), true);
        if (unicodeForced) {
            DrawUtil.stopUnicode(this.field_146297_k.field_71466_p);
        }
        this.drawLogo();
        this.sizeDisplay(true);
        timer.stop();
    }

    private int getMapFontScale() {
        return (this.fullMapProperties.fontSmall.get() ? 1 : 2) * (this.fullMapProperties.forceUnicode.get() ? 2 : 1);
    }

    public void centerOn(Waypoint waypoint) {
        if (waypoint.getDimensions().contains(this.field_146297_k.field_71439_g.field_71093_bK)) {
            MapOverlay.state.follow = false;
            state.requireRefresh();
            int x = waypoint.getX();
            int z = waypoint.getZ();
            gridRenderer.center(x, z, MapOverlay.state.currentZoom);
            this.refreshState();
            this.func_73876_c();
        }
    }

    void refreshState() {
        EntityClientPlayerMP player = this.field_146297_k.field_71439_g;
        if (player == null) {
            this.logger.warning("Could not get player");
            return;
        }
        state.refresh(this.field_146297_k, player, this.fullMapProperties);
        if (state.getDimension() != gridRenderer.getDimension()) {
            this.setFollow(true);
        }
        gridRenderer.setContext(state.getWorldDir(), state.getDimension());
        if (MapOverlay.state.follow) {
            gridRenderer.center(this.field_146297_k.field_71439_g.field_70165_t, this.field_146297_k.field_71439_g.field_70161_v, MapOverlay.state.currentZoom);
        } else {
            gridRenderer.setZoom(MapOverlay.state.currentZoom);
        }
        gridRenderer.updateTextures(state.getMapType(this.fullMapProperties.showCaves.get()), state.getVSlice(), this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d, true, 0.0, 0.0, this.fullMapProperties);
        state.generateDrawSteps(this.field_146297_k, gridRenderer, this.waypointRenderer, this.radarRenderer, this.fullMapProperties, 1.0f, false);
        MapOverlay.state.playerLastPos = Constants.getString("MapOverlay.location_xzyeb", Integer.toString((int)this.field_146297_k.field_71439_g.field_70165_t), Integer.toString((int)this.field_146297_k.field_71439_g.field_70161_v), Integer.toString((int)this.field_146297_k.field_71439_g.field_70163_u), this.field_146297_k.field_71439_g.field_70162_ai, state.getPlayerBiome());
        state.updateLastRefresh();
        TileCache.instance().cleanUp();
    }

    void openChat(String defaultText) {
        if (this.chat != null) {
            this.chat.setText(defaultText);
            this.chat.setHidden(false);
        } else {
            this.chat = new MapChat(defaultText, false);
            this.chat.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        }
    }

    @Override
    public void close() {
        if (this.chat != null) {
            this.chat.close();
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    boolean isRefreshReady() {
        if (this.isScrolling.booleanValue()) {
            return false;
        }
        return state.shouldRefresh(this.field_146297_k);
    }

    void moveCanvas(int deltaBlockX, int deltaBlockz) {
        this.refreshState();
        gridRenderer.move(deltaBlockX, deltaBlockz);
        gridRenderer.updateTextures(state.getMapType(this.fullMapProperties.showCaves.get()), state.getVSlice(), this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d, true, 0.0, 0.0, this.fullMapProperties);
        this.setFollow(false);
    }

    @Override
    public final boolean func_73868_f() {
        return false;
    }

    public static synchronized MapOverlayState state() {
        return state;
    }

    public static void reset() {
        state.requireRefresh();
        gridRenderer.clear();
        TileCache.instance().invalidateAll();
        TileCache.instance().cleanUp();
    }

    private static enum ButtonEnum {
        Alert,
        DayNight,
        Follow,
        ZoomIn,
        ZoomOut,
        Options,
        Actions,
        Close,
        Mode,
        WaypointManager,
        Caves;

    }
}

