/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.map.layer;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.chunk.Chunk;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.data.WaypointsData;
import net.techbrew.journeymap.model.BlockCoordIntPair;
import net.techbrew.journeymap.model.Waypoint;
import net.techbrew.journeymap.render.draw.DrawStep;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.draw.DrawWayPointStep;
import net.techbrew.journeymap.render.overlay.GridRenderer;
import net.techbrew.journeymap.ui.UIManager;
import net.techbrew.journeymap.ui.map.MapOverlay;
import net.techbrew.journeymap.ui.map.layer.LayerDelegate;
import org.lwjgl.input.Mouse;

public class WaypointLayer
implements LayerDelegate.Layer {
    private final long hoverDelay = 100L;
    private final List<DrawStep> drawStepList = new ArrayList<DrawStep>(1);
    private final BlockOutlineDrawStep clickDrawStep = new BlockOutlineDrawStep(new BlockCoordIntPair(0, 0));
    BlockCoordIntPair lastCoord = null;
    long lastClick = 0L;
    long startHover = 0L;
    DrawWayPointStep selectedWaypointStep = null;
    Waypoint selected = null;

    @Override
    public List<DrawStep> onMouseMove(Minecraft mc, double mouseX, double mouseY, int gridWidth, int gridHeight, BlockCoordIntPair blockCoord) {
        if (!WaypointsData.isManagerEnabled()) {
            return Collections.EMPTY_LIST;
        }
        this.drawStepList.clear();
        this.drawStepList.add(this.clickDrawStep);
        if (this.lastCoord == null) {
            this.lastCoord = blockCoord;
        }
        long now = Minecraft.func_71386_F();
        if (!blockCoord.equals(this.clickDrawStep.blockCoord)) {
            this.unclick();
        }
        int proximity = this.getProximity();
        AxisAlignedBB area = AxisAlignedBB.func_72330_a((double)(blockCoord.x - proximity), (double)-1.0, (double)(blockCoord.z - proximity), (double)(blockCoord.x + proximity), (double)(mc.field_71441_e.func_72940_L() + 1), (double)(blockCoord.z + proximity));
        if (!this.lastCoord.equals(blockCoord)) {
            if (!area.func_72318_a(Vec3.func_72443_a((double)this.lastCoord.x, (double)1.0, (double)this.lastCoord.z))) {
                this.selected = null;
                this.lastCoord = blockCoord;
                this.startHover = now;
                return Collections.EMPTY_LIST;
            }
        } else if (this.selected != null) {
            this.select(this.selected);
            return this.drawStepList;
        }
        if (now - this.startHover < 100L) {
            return Collections.EMPTY_LIST;
        }
        int dimension = mc.field_71439_g.field_71093_bK;
        Collection<Waypoint> waypoints = DataCache.instance().getWaypoints(false);
        ArrayList<Waypoint> proximal = new ArrayList<Waypoint>();
        for (Waypoint waypoint : waypoints) {
            if (waypoint.isReadOnly() || !waypoint.isEnable() || !waypoint.isInPlayerDimension() || !area.func_72318_a(Vec3.func_72443_a((double)waypoint.getX(), (double)waypoint.getY(), (double)waypoint.getZ()))) continue;
            proximal.add(waypoint);
        }
        if (!proximal.isEmpty()) {
            if (proximal.size() > 1) {
                this.sortByDistance(proximal, blockCoord, dimension);
            }
            this.select((Waypoint)proximal.get(0));
        }
        return this.drawStepList;
    }

    @Override
    public List<DrawStep> onMouseClick(Minecraft mc, double mouseX, double mouseY, int gridWidth, int gridHeight, BlockCoordIntPair blockCoord) {
        if (!WaypointsData.isManagerEnabled()) {
            return Collections.EMPTY_LIST;
        }
        long sysTime = Minecraft.func_71386_F();
        boolean doubleClick = sysTime - this.lastClick < 450L;
        this.lastClick = sysTime;
        if (!this.drawStepList.contains(this.clickDrawStep)) {
            this.drawStepList.add(this.clickDrawStep);
        }
        if (!doubleClick || !blockCoord.equals(this.clickDrawStep.blockCoord)) {
            this.clickDrawStep.blockCoord = blockCoord;
            return this.drawStepList;
        }
        if (this.selected != null) {
            UIManager.getInstance().openWaypointManager(this.selected, MapOverlay.class);
            return this.drawStepList;
        }
        Chunk chunk = mc.field_71441_e.func_72964_e(blockCoord.x >> 4, blockCoord.z >> 4);
        int y = -1;
        if (!chunk.func_76621_g()) {
            y = Math.max(1, chunk.func_76626_d(blockCoord.x & 0xF, blockCoord.z & 0xF));
        }
        ChunkCoordinates cc = new ChunkCoordinates(blockCoord.x, y, blockCoord.z);
        Waypoint waypoint = Waypoint.at(cc, Waypoint.Type.Normal, mc.field_71439_g.field_71093_bK);
        UIManager.getInstance().openWaypointEditor(waypoint, true, MapOverlay.class);
        return this.drawStepList;
    }

    private void sortByDistance(List<Waypoint> waypoints, final BlockCoordIntPair blockCoord, int dimension) {
        Collections.sort(waypoints, new Comparator<Waypoint>(){

            @Override
            public int compare(Waypoint o1, Waypoint o2) {
                return Double.compare(this.getDistance(o1), this.getDistance(o2));
            }

            private double getDistance(Waypoint waypoint) {
                double dx = waypoint.getX() - blockCoord.x;
                double dz = waypoint.getZ() - blockCoord.z;
                return Math.sqrt(dx * dx + dz * dz);
            }
        });
    }

    private void select(Waypoint waypoint) {
        this.selected = waypoint;
        this.selectedWaypointStep = new DrawWayPointStep(waypoint, waypoint.getColor(), Color.white, true);
        this.drawStepList.add(this.selectedWaypointStep);
    }

    private int getProximity() {
        int blockSize = (int)Math.max(1.0, Math.pow(2.0, MapOverlay.state().currentZoom));
        return Math.max(1, 8 / blockSize);
    }

    private void unclick() {
        this.clickDrawStep.blockCoord = new BlockCoordIntPair(Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.drawStepList.remove(this.clickDrawStep);
    }

    class BlockOutlineDrawStep
    implements DrawStep {
        BlockCoordIntPair blockCoord;

        BlockOutlineDrawStep(BlockCoordIntPair blockCoord) {
            this.blockCoord = blockCoord;
        }

        @Override
        public void draw(double xOffset, double yOffset, GridRenderer gridRenderer, float drawScale, double fontScale) {
            if (Mouse.isButtonDown((int)0)) {
                return;
            }
            if (xOffset != 0.0 || yOffset != 0.0) {
                WaypointLayer.this.unclick();
                return;
            }
            double x = this.blockCoord.x;
            double z = this.blockCoord.z;
            double size = Math.pow(2.0, gridRenderer.getZoom());
            double thick = gridRenderer.getZoom() < 2 ? 1.0 : 2.0;
            Point2D.Double pixel = gridRenderer.getBlockPixelInGrid(x, z);
            pixel.setLocation(pixel.getX() + xOffset, pixel.getY() + yOffset);
            if (gridRenderer.isOnScreen(pixel)) {
                DrawUtil.drawRectangle(pixel.getX() - thick * thick, pixel.getY() - thick * thick, size + thick * 4.0, thick, Color.black, 150);
                DrawUtil.drawRectangle(pixel.getX() - thick, pixel.getY() - thick, size + thick * thick, thick, Color.white, 255);
                DrawUtil.drawRectangle(pixel.getX() - thick * thick, pixel.getY() - thick, thick, size + thick * thick, Color.black, 150);
                DrawUtil.drawRectangle(pixel.getX() - thick, pixel.getY(), thick, size, Color.white, 255);
                DrawUtil.drawRectangle(pixel.getX() + size, pixel.getY(), thick, size, Color.white, 255);
                DrawUtil.drawRectangle(pixel.getX() + size + thick, pixel.getY() - thick, thick, size + thick * thick, Color.black, 150);
                DrawUtil.drawRectangle(pixel.getX() - thick, pixel.getY() + size, size + thick * thick, thick, Color.white, 255);
                DrawUtil.drawRectangle(pixel.getX() - thick * thick, pixel.getY() + size + thick, size + thick * 4.0, thick, Color.black, 150);
            }
        }
    }
}

