/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.minimap;

import java.awt.Color;
import net.minecraft.client.gui.GuiButton;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.properties.MiniMapProperties;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.ui.BooleanPropertyButton;
import net.techbrew.journeymap.ui.Button;
import net.techbrew.journeymap.ui.ButtonList;
import net.techbrew.journeymap.ui.JmUI;
import net.techbrew.journeymap.ui.MasterOptions;
import net.techbrew.journeymap.ui.UIManager;
import net.techbrew.journeymap.ui.minimap.DisplayVars;
import net.techbrew.journeymap.ui.minimap.MiniMap;

public class MiniMapOptions
extends JmUI {
    private Button buttonPosition;
    private Button buttonShape;
    private Button buttonFont;
    private Button buttonTexture;
    private Button buttonUnicode;
    private Button buttonMiniMap;
    private Button buttonKeyboard;
    private Button buttonKeyboardHelp;
    private Button buttonShowSelf;
    private Button buttonShowfps;
    private Button buttonGeneralDisplay;
    private Button buttonClose;
    private Button buttonCloseAll;
    private DisplayVars.Shape currentShape;
    private DisplayVars.Position currentPosition;
    private ButtonList leftButtons;
    private ButtonList rightButtons;
    private MiniMapProperties miniMapProperties;

    public MiniMapOptions() {
        this(MasterOptions.class);
    }

    public MiniMapOptions(Class<? extends JmUI> returnClass) {
        super(Constants.getString("MiniMap.options"), returnClass);
        this.miniMapProperties = JourneyMap.getInstance().miniMapProperties;
    }

    @Override
    public void func_73866_w_() {
        this.field_146292_n.clear();
        String on = Constants.getString("MapOverlay.on");
        String off = Constants.getString("MapOverlay.off");
        boolean minimapOn = this.miniMapProperties.enabled.get();
        this.buttonMiniMap = new Button((Enum)ButtonEnum.MiniMap, Constants.getString("MiniMap.enable_minimap", on), Constants.getString("MiniMap.enable_minimap", off), minimapOn);
        this.buttonMiniMap.setToggled(minimapOn);
        DisplayVars.Position position = DisplayVars.Position.getPreferred();
        this.buttonPosition = new Button(ButtonEnum.Position, "");
        this.setPosition(position);
        this.buttonPosition.setEnabled(minimapOn);
        DisplayVars.Shape shape = DisplayVars.Shape.getPreferred();
        this.buttonShape = new Button(ButtonEnum.Shape, "");
        this.setShape(shape);
        this.buttonShape.setEnabled(minimapOn);
        this.buttonFont = new Button((Enum)ButtonEnum.Font, Constants.getString("MiniMap.font", Constants.getString("MiniMap.font_small")), Constants.getString("MiniMap.font", Constants.getString("MiniMap.font_large")), this.miniMapProperties.fontSmall.get());
        this.buttonFont.setEnabled(minimapOn);
        this.buttonTexture = new BooleanPropertyButton(ButtonEnum.Texture.ordinal(), Constants.getString("MiniMap.texture_size", Constants.getString("MiniMap.font_small")), Constants.getString("MiniMap.texture_size", Constants.getString("MiniMap.font_large")), this.miniMapProperties, this.miniMapProperties.textureSmall);
        this.buttonTexture.setEnabled(minimapOn);
        this.buttonShowSelf = new BooleanPropertyButton(ButtonEnum.ShowSelf.ordinal(), Constants.getString("MapOverlay.show_self", Constants.getString("MapOverlay.on")), Constants.getString("MapOverlay.show_self", Constants.getString("MapOverlay.off")), this.miniMapProperties, this.miniMapProperties.showSelf);
        this.buttonShowSelf.setEnabled(minimapOn);
        boolean showHotKeys = this.miniMapProperties.enableHotkeys.get();
        this.buttonKeyboard = new Button((Enum)ButtonEnum.Keyboard, Constants.getString("MiniMap.hotkeys", on), Constants.getString("MiniMap.hotkeys", off), showHotKeys);
        this.buttonKeyboard.setEnabled(minimapOn);
        this.buttonKeyboardHelp = new Button(ButtonEnum.KeyboardHelp, Constants.getString("MapOverlay.hotkeys_button"));
        boolean isShowFps = this.miniMapProperties.showFps.get();
        this.buttonShowfps = new Button((Enum)ButtonEnum.Showfps, Constants.getString("MiniMap.show_fps", on), Constants.getString("MiniMap.show_fps", off), isShowFps);
        this.buttonShowfps.setEnabled(minimapOn);
        boolean forceUnicode = this.miniMapProperties.forceUnicode.get();
        this.buttonUnicode = new Button((Enum)ButtonEnum.Unicode, Constants.getString("MiniMap.force_unicode", on), Constants.getString("MiniMap.force_unicode", off), forceUnicode);
        this.buttonGeneralDisplay = new Button(ButtonEnum.GeneralDisplay, Constants.getString("MapOverlay.general_display_button"));
        this.leftButtons = new ButtonList(this.buttonShape, this.buttonShowfps, this.buttonShowSelf, this.buttonKeyboard, this.buttonKeyboardHelp);
        this.leftButtons.setNoDisableText(true);
        this.rightButtons = new ButtonList(this.buttonPosition, this.buttonTexture, this.buttonFont, this.buttonUnicode, this.buttonGeneralDisplay);
        this.rightButtons.setNoDisableText(true);
        this.field_146292_n.add(this.buttonMiniMap);
        this.field_146292_n.addAll(this.leftButtons);
        this.field_146292_n.addAll(this.rightButtons);
        new ButtonList(this.field_146292_n).equalizeWidths(this.getFontRenderer());
        this.buttonClose = new Button(ButtonEnum.Close, Constants.getString("MapOverlay.close"));
        this.buttonClose.setWidth(150);
        this.buttonCloseAll = new Button(ButtonEnum.CloseAll, Constants.getString("MiniMap.return_to_game"));
        this.buttonCloseAll.setWidth(150);
        this.field_146292_n.add(this.buttonClose);
        this.field_146292_n.add(this.buttonCloseAll);
    }

    @Override
    protected void layoutButtons() {
        if (this.field_146292_n.isEmpty()) {
            this.func_73866_w_();
        }
        int hgap = 2;
        int vgap = 3;
        int bx = this.field_146294_l / 2;
        int by = Math.max(40, (this.field_146295_m - 192) / 2);
        this.buttonMiniMap.centerHorizontalOn(bx).setY(by);
        this.leftButtons.layoutVertical(bx - 2, this.buttonMiniMap.getBottomY() + 3, false, 3);
        this.rightButtons.layoutVertical(bx + 2, this.buttonMiniMap.getBottomY() + 3, true, 3);
        for (Button button : this.leftButtons) {
            button.setEnabled(this.buttonMiniMap.getToggled());
        }
        for (Button button : this.rightButtons) {
            button.setEnabled(this.buttonMiniMap.getToggled());
        }
        this.buttonMiniMap.setEnabled(true);
        this.buttonCloseAll.below(this.leftButtons, 9).centerHorizontalOn(bx);
        this.buttonClose.below(this.buttonCloseAll, 3).centerHorizontalOn(bx);
        this.buttonKeyboardHelp.setEnabled(this.buttonMiniMap.getToggled() != false && this.buttonKeyboard.getToggled() != false);
    }

    protected void func_146284_a(GuiButton guibutton) {
        ButtonEnum id = ButtonEnum.values()[guibutton.field_146127_k];
        switch (id) {
            case MiniMap: {
                UIManager uim = UIManager.getInstance();
                boolean enabled = !uim.isMiniMapEnabled();
                this.miniMapProperties.enabled.set(enabled);
                this.miniMapProperties.save();
                this.buttonMiniMap.setToggled(enabled);
                uim.setMiniMapEnabled(enabled);
                break;
            }
            case Shape: {
                this.nextShape();
                break;
            }
            case Position: {
                this.nextPosition();
                break;
            }
            case Font: {
                this.buttonFont.setToggled(this.miniMapProperties.toggle(this.miniMapProperties.fontSmall));
                UIManager.getInstance().getMiniMap().updateDisplayVars(true);
                break;
            }
            case ShowSelf: {
                this.buttonShowSelf.toggle();
                break;
            }
            case Texture: {
                this.buttonTexture.toggle();
                UIManager.getInstance().getMiniMap().updateDisplayVars(true);
                break;
            }
            case Keyboard: {
                this.buttonKeyboard.setToggled(this.miniMapProperties.toggle(this.miniMapProperties.enableHotkeys));
                break;
            }
            case KeyboardHelp: {
                UIManager.getInstance().openMiniMapHotkeyHelp(((Object)((Object)this)).getClass());
                break;
            }
            case Showfps: {
                this.buttonShowfps.setToggled(this.miniMapProperties.toggle(this.miniMapProperties.showFps));
                UIManager.getInstance().getMiniMap().updateDisplayVars(true);
                break;
            }
            case Unicode: {
                this.buttonUnicode.setToggled(this.miniMapProperties.toggle(this.miniMapProperties.forceUnicode));
                UIManager.getInstance().getMiniMap().updateDisplayVars(true);
                break;
            }
            case GeneralDisplay: {
                UIManager.getInstance().openGeneralDisplayOptions(((Object)((Object)this)).getClass());
                break;
            }
            case Close: {
                this.closeAndReturn();
                break;
            }
            case CloseAll: {
                UIManager.getInstance().closeAll();
            }
        }
    }

    public void nextShape() {
        int nextIndex = this.currentShape.ordinal() + 1;
        if (nextIndex == DisplayVars.Shape.Enabled.length) {
            nextIndex = 0;
        }
        this.setShape(DisplayVars.Shape.Enabled[nextIndex]);
    }

    private void setShape(DisplayVars.Shape shape) {
        if (!shape.isEnabled()) {
            shape = DisplayVars.Shape.Enabled[0];
        }
        this.currentShape = shape;
        this.buttonShape.field_146126_j = Constants.getString("MiniMap.shape", Constants.getString(this.currentShape.label));
        UIManager.getInstance().getMiniMap().setShape(shape);
    }

    private void nextPosition() {
        int nextIndex = this.currentPosition.ordinal() + 1;
        if (nextIndex == DisplayVars.Position.values().length) {
            nextIndex = 0;
        }
        this.setPosition(DisplayVars.Position.values()[nextIndex]);
    }

    private void setPosition(DisplayVars.Position position) {
        this.currentPosition = position;
        this.buttonPosition.field_146126_j = Constants.getString("MiniMap.position", Constants.getString(this.currentPosition.label));
        UIManager.getInstance().getMiniMap().setPosition(position);
    }

    @Override
    public void func_73863_a(int x, int y, float par3) {
        int idx;
        this.func_146278_c(0);
        this.layoutButtons();
        this.drawTitle();
        this.drawLogo();
        if (JourneyMap.getInstance().miniMapProperties.enabled.get()) {
            MiniMap miniMap = UIManager.getInstance().getMiniMap();
            miniMap.drawMap();
        }
        for (int k = 0; k < this.field_146292_n.size(); ++k) {
            GuiButton guibutton = (GuiButton)this.field_146292_n.get(k);
            guibutton.func_146112_a(this.field_146297_k, x, y);
        }
        String fps = this.field_146297_k.field_71426_K;
        int n = idx = fps != null ? fps.indexOf(44) : -1;
        if (idx > 0) {
            fps = fps.substring(0, idx);
            if (this.currentPosition == DisplayVars.Position.TopRight) {
                DrawUtil.drawLabel(fps, this.field_146294_l - 5, this.field_146295_m - 5, DrawUtil.HAlign.Left, DrawUtil.VAlign.Above, Color.BLACK, 0, Color.cyan, 255, 1.0, true);
            } else {
                DrawUtil.drawLabel(fps, this.field_146294_l - 5, 5.0, DrawUtil.HAlign.Left, DrawUtil.VAlign.Below, Color.BLACK, 0, Color.cyan, 255, 1.0, true);
            }
        }
    }

    private static enum ButtonEnum {
        MiniMap,
        Position,
        Shape,
        Font,
        Texture,
        Unicode,
        Keyboard,
        KeyboardHelp,
        Close,
        Showfps,
        ShowSelf,
        GeneralDisplay,
        CloseAll;

    }
}

