/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import gnu.trove.map.hash.TByteObjectHashMap;
import gnu.trove.map.hash.TObjectByteHashMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.AttributeKey;
import java.lang.ref.WeakReference;
import java.util.List;
import org.apache.logging.log4j.Level;

@ChannelHandler.Sharable
public abstract class FMLIndexedMessageToMessageCodec<A>
extends MessageToMessageCodec<FMLProxyPacket, A> {
    private TByteObjectHashMap<Class<? extends A>> discriminators = new TByteObjectHashMap();
    private TObjectByteHashMap<Class<? extends A>> types = new TObjectByteHashMap();
    public static final AttributeKey<ThreadLocal<WeakReference<FMLProxyPacket>>> INBOUNDPACKETTRACKER = new AttributeKey("fml:inboundpacket");

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        ctx.attr(INBOUNDPACKETTRACKER).set(new ThreadLocal());
    }

    public FMLIndexedMessageToMessageCodec<A> addDiscriminator(int discriminator, Class<? extends A> type) {
        this.discriminators.put((byte)discriminator, type);
        this.types.put(type, (byte)discriminator);
        return this;
    }

    public abstract void encodeInto(ChannelHandlerContext var1, A var2, ByteBuf var3) throws Exception;

    protected final void encode(ChannelHandlerContext ctx, A msg, List<Object> out) throws Exception {
        FMLProxyPacket old;
        ByteBuf buffer = Unpooled.buffer();
        Class<?> clazz = msg.getClass();
        byte discriminator = this.types.get(clazz);
        buffer.writeByte((int)discriminator);
        this.encodeInto(ctx, msg, buffer);
        FMLProxyPacket proxy = new FMLProxyPacket(buffer.copy(), (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get());
        WeakReference ref = (WeakReference)((ThreadLocal)ctx.attr(INBOUNDPACKETTRACKER).get()).get();
        FMLProxyPacket fMLProxyPacket = old = ref == null ? null : (FMLProxyPacket)((Object)ref.get());
        if (old != null) {
            proxy.setDispatcher(old.getDispatcher());
        }
        out.add((Object)proxy);
    }

    public abstract void decodeInto(ChannelHandlerContext var1, ByteBuf var2, A var3);

    protected final void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        this.testMessageValidity(msg);
        ByteBuf payload = msg.payload();
        byte discriminator = payload.readByte();
        Class clazz = (Class)this.discriminators.get(discriminator);
        if (clazz == null) {
            throw new NullPointerException("Undefined message for discriminator " + discriminator + " in channel " + msg.channel());
        }
        Object newMsg = clazz.newInstance();
        ((ThreadLocal)ctx.attr(INBOUNDPACKETTRACKER).get()).set(new WeakReference<FMLProxyPacket>(msg));
        this.decodeInto(ctx, payload.slice(), newMsg);
        out.add(newMsg);
    }

    protected void testMessageValidity(FMLProxyPacket msg) {
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        FMLLog.log(Level.ERROR, cause, "FMLIndexedMessageCodec exception caught", new Object[0]);
        super.exceptionCaught(ctx, cause);
    }
}

