/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.player;

import cpw.mods.fml.common.eventhandler.Cancelable;
import java.io.File;
import net.minecraftforge.event.entity.living.LivingEvent;

public class PlayerEvent
extends LivingEvent {
    public final yz entityPlayer;

    public PlayerEvent(yz player) {
        super((sv)player);
        this.entityPlayer = player;
    }

    public static class SaveToFile
    extends PlayerEvent {
        public final File playerDirectory;
        public final String playerUUID;

        public SaveToFile(yz player, File originDirectory, String playerUUID) {
            super(player);
            this.playerDirectory = originDirectory;
            this.playerUUID = playerUUID;
        }

        public File getPlayerFile(String suffix) {
            if ("dat".equals(suffix)) {
                throw new IllegalArgumentException("The suffix 'dat' is reserved");
            }
            return new File(this.playerDirectory, this.playerUUID + "." + suffix);
        }
    }

    public static class LoadFromFile
    extends PlayerEvent {
        public final File playerDirectory;
        public final String playerUUID;

        public LoadFromFile(yz player, File originDirectory, String playerUUID) {
            super(player);
            this.playerDirectory = originDirectory;
            this.playerUUID = playerUUID;
        }

        public File getPlayerFile(String suffix) {
            if ("dat".equals(suffix)) {
                throw new IllegalArgumentException("The suffix 'dat' is reserved");
            }
            return new File(this.playerDirectory, this.playerUUID + "." + suffix);
        }
    }

    public static class StopTracking
    extends PlayerEvent {
        public final sa target;

        public StopTracking(yz player, sa target) {
            super(player);
            this.target = target;
        }
    }

    public static class StartTracking
    extends PlayerEvent {
        public final sa target;

        public StartTracking(yz player, sa target) {
            super(player);
            this.target = target;
        }
    }

    public static class Clone
    extends PlayerEvent {
        public final yz original;
        public final boolean wasDeath;

        public Clone(yz _new, yz oldPlayer, boolean wasDeath) {
            super(_new);
            this.original = oldPlayer;
            this.wasDeath = wasDeath;
        }
    }

    public static class NameFormat
    extends PlayerEvent {
        public final String username;
        public String displayname;

        public NameFormat(yz player, String username) {
            super(player);
            this.username = username;
            this.displayname = username;
        }
    }

    @Cancelable
    public static class BreakSpeed
    extends PlayerEvent {
        public final aji block;
        public final int metadata;
        public final float originalSpeed;
        public float newSpeed = 0.0f;
        public final int x;
        public final int y;
        public final int z;

        @Deprecated
        public BreakSpeed(yz player, aji block, int metadata, float original) {
            this(player, block, metadata, original, 0, -1, 0);
        }

        public BreakSpeed(yz player, aji block, int metadata, float original, int x, int y2, int z2) {
            super(player);
            this.block = block;
            this.metadata = metadata;
            this.originalSpeed = original;
            this.newSpeed = original;
            this.x = x;
            this.y = y2;
            this.z = z2;
        }
    }

    public static class HarvestCheck
    extends PlayerEvent {
        public final aji block;
        public boolean success;

        public HarvestCheck(yz player, aji block, boolean success) {
            super(player);
            this.block = block;
            this.success = success;
        }
    }
}

